/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.collection;

import com.google.common.collect.Maps;
import java.util.Map;

public class EnvBuilder {
    private Map<String, Object> map = Maps.newHashMap();

    private EnvBuilder() {
    }

    public static EnvBuilder builder() {
        return new EnvBuilder();
    }

    public EnvBuilder put(String key, Object value) {
        if (value == null) {
            return this;
        }
        String[] segments = key.split("\\.");
        Map cur = this.map;
        int size = segments.length;
        for (int i = 0; i < size - 1; ++i) {
            String segment = segments[i];
            if (!cur.containsKey(segment)) {
                cur.put((String)segment, (Object)Maps.newHashMap());
            }
            Object entryValue = cur.get(segment);
            try {
                cur = (Map)entryValue;
                continue;
            }
            catch (ClassCastException e) {
                String propertyPrefix = this.getPropertyPrefix(segments, i);
                throw new RuntimeException(propertyPrefix + "='" + entryValue.getClass().getName() + "' is incompatible with 'java.util.Map<String, Object>'");
            }
        }
        cur.put((String)segments[size - 1], (Object)value);
        return this;
    }

    private String getPropertyPrefix(String[] segments, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(segments[0]);
        for (int i = 1; i <= index; ++i) {
            sb.append('.').append(segments[i]);
        }
        return sb.toString();
    }

    public Map<String, Object> build() {
        return this.map;
    }
}

