/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.number;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.common.tools.number.IDGenerator;

public class SnowFlakeIDGenerator
implements IDGenerator {
    private static final long TWEPOCH = 1288834974657L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long MAX_WORKER_ID = 1023L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private final int workerId;
    private int sequence;
    private long lastTimestamp = -1L;

    public SnowFlakeIDGenerator(int workerId) {
        Assert.assertTrue(workerId >= 0 && (long)workerId <= 1023L, () -> String.format("workerId must between 1 and %d", 1023L));
        this.workerId = workerId;
    }

    @Override
    public synchronized long nextId() {
        long timestamp = this.timeGen();
        Assert.assertTrue(timestamp >= this.lastTimestamp, "clock is moving backwards");
        if (timestamp == this.lastTimestamp) {
            ++this.sequence;
            if ((long)this.sequence == 4096L) {
                this.sequence = 0;
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1288834974657L << 22 | (long)(this.workerId << 12) | (long)this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

