/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.promise;

import com.github.liuyehcf.framework.common.tools.promise.Promise;
import com.github.liuyehcf.framework.common.tools.promise.PromiseException;
import com.github.liuyehcf.framework.common.tools.promise.PromiseListener;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPromise<T>
implements Promise<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPromise.class);
    private final List<PromiseListenerWrapper<T>> listeners = Lists.newCopyOnWriteArrayList();
    private final ReentrantLock waitLock = new ReentrantLock();
    private final Condition completeCondition = this.waitLock.newCondition();
    private volatile T outcome;
    private volatile boolean isCanceled = false;
    private volatile boolean isDone = false;
    private volatile boolean isSuccess = false;
    private volatile boolean isFailure = false;
    private volatile Throwable cause;

    @Override
    public final boolean isCancelled() {
        return this.isCanceled;
    }

    @Override
    public final boolean isDone() {
        return this.isDone;
    }

    @Override
    public final boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public final boolean isFailure() {
        return this.isFailure;
    }

    @Override
    public final Throwable cause() {
        return this.cause;
    }

    @Override
    public final boolean tryCancel() {
        if (this.isDone()) {
            return false;
        }
        boolean result = this.executeSynchronousUnderLock(() -> {
            if (this.isDone()) {
                return false;
            }
            this.setCanceledUnderLock();
            return true;
        });
        this.notifyAllListeners();
        return result;
    }

    @Override
    public final boolean trySuccess(T outcome) {
        if (this.isDone()) {
            return false;
        }
        boolean result = this.executeSynchronousUnderLock(() -> {
            if (this.isDone()) {
                return false;
            }
            this.setSuccessUnderLock(outcome);
            return true;
        });
        this.notifyAllListeners();
        return result;
    }

    @Override
    public final boolean tryFailure(Throwable cause) {
        if (this.isDone()) {
            return false;
        }
        boolean result = this.executeSynchronousUnderLock(() -> {
            if (this.isDone()) {
                return false;
            }
            this.setFailureUnderLock(cause);
            return true;
        });
        this.notifyAllListeners();
        return result;
    }

    @Override
    public final Promise<T> addListener(PromiseListener<T> listener) {
        this.addListener0(listener);
        if (this.isDone()) {
            this.notifyAllListeners();
        }
        return this;
    }

    @Override
    public final void sync() {
        if (this.isDone()) {
            return;
        }
        this.executeSynchronousUnderLock(() -> {
            if (this.isDone()) {
                return null;
            }
            this.completeCondition.await();
            return null;
        });
    }

    @Override
    public final boolean await(long timeout, TimeUnit unit) {
        if (this.isDone()) {
            return true;
        }
        return this.executeSynchronousUnderLock(() -> {
            if (this.isDone()) {
                return true;
            }
            return this.completeCondition.await(timeout, unit);
        });
    }

    @Override
    public final T get() {
        if (this.isDone()) {
            return this.report(false);
        }
        return (T)this.executeSynchronousUnderLock(() -> {
            if (this.isDone()) {
                return this.report(false);
            }
            this.completeCondition.await();
            return this.report(false);
        });
    }

    @Override
    public final T get(long timeout, TimeUnit unit) {
        if (this.isDone()) {
            return this.report(false);
        }
        return (T)this.executeSynchronousUnderLock(() -> {
            if (this.isDone()) {
                return this.report(false);
            }
            long nanoTimeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
            long start = System.nanoTime();
            this.completeCondition.await(timeout, unit);
            long end = System.nanoTime();
            return this.report(end - start > nanoTimeout);
        });
    }

    private void addListener0(PromiseListener<T> listener) {
        this.listeners.add(new PromiseListenerWrapper(listener));
    }

    private void notifyAllListeners() {
        for (PromiseListener promiseListener : this.listeners) {
            try {
                promiseListener.operationComplete(this);
            }
            catch (Throwable e) {
                LOGGER.warn("an exception was thrown by {}.operationComplete()", (Object)promiseListener.getClass().getName(), (Object)e);
            }
        }
    }

    private <F> F executeSynchronousUnderLock(InterruptCallable<F> callable) {
        try {
            this.waitLock.lock();
            F f = callable.call();
            return f;
        }
        catch (InterruptedException | ExecutionException e) {
            throw this.createException(e);
        }
        finally {
            this.waitLock.unlock();
        }
    }

    private void setCanceledUnderLock() {
        this.isFailure = true;
        this.isCanceled = true;
        this.isDone = true;
        this.completeCondition.signalAll();
    }

    private void setSuccessUnderLock(T outcome) {
        this.isSuccess = true;
        this.outcome = outcome;
        this.isDone = true;
        this.completeCondition.signalAll();
    }

    private void setFailureUnderLock(Throwable cause) {
        this.isFailure = true;
        this.cause = cause;
        this.isDone = true;
        this.completeCondition.signalAll();
    }

    private T report(boolean isTimeout) {
        if (this.isSuccess()) {
            return this.outcome;
        }
        if (this.isCancelled()) {
            throw this.createException("promise canceled");
        }
        if (isTimeout) {
            throw this.createException("promise timeout");
        }
        throw this.createException("promise failed", this.cause());
    }

    protected RuntimeException createException(Throwable cause) {
        return new PromiseException(cause);
    }

    protected RuntimeException createException(String description) {
        return new PromiseException(description);
    }

    protected RuntimeException createException(String description, Throwable cause) {
        return new PromiseException(description, cause);
    }

    private static final class PromiseListenerWrapper<T>
    implements PromiseListener<T> {
        private final PromiseListener<T> target;
        private final AtomicBoolean isTriggered = new AtomicBoolean(false);

        private PromiseListenerWrapper(PromiseListener<T> target) {
            this.target = target;
        }

        @Override
        public void operationComplete(Promise<T> promise) throws Throwable {
            if (this.isTriggered.compareAndSet(false, true)) {
                this.target.operationComplete(promise);
            }
        }
    }

    private static interface InterruptCallable<T> {
        public T call() throws InterruptedException, ExecutionException;
    }
}

