/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class BeanFiller {
    private static final Byte BYTE_DEFAULT_VALUE = 1;
    private static final Character CHAR_DEFAULT_VALUE = Character.valueOf('a');
    private static final Short SHORT_DEFAULT_VALUE = 2;
    private static final Integer INTEGER_DEFAULT_VALUE = 3;
    private static final Long LONG_DEFAULT_VALUE = 6L;
    private static final Float FLOAT_DEFAULT_VALUE = Float.valueOf(1.0f);
    private static final Double DOUBLE_DEFAULT_VALUE = 2.0;
    private static final String STRING_DEFAULT_VALUE = "default";
    private static final Map<Class<?>, Object> DEFAULT_VALUE_OF_BASIC_CLASS = new HashMap();
    private static final String SET_METHOD_PREFIX = "set";
    private static final Integer SET_METHOD_PARAM_COUNT = 1;
    private static final Class<?> SET_METHOD_RETURN_TYPE = Void.TYPE;
    private static final Set<Class<?>> CONTAINER_CLASS_SET = new HashSet();
    private static final Integer CONTAINER_DEFAULT_SIZE = 3;
    private final Type type;
    private Map<String, Type> genericTypes;

    private BeanFiller(Type type, Map<String, Type> superClassGenericTypes) {
        this.type = type;
        this.genericTypes = new HashMap<String, Type>();
        this.initGenericTypes(superClassGenericTypes);
    }

    public static <T> T fill(TypeReference<T> typeReference) {
        if (typeReference == null) {
            throw new NullPointerException();
        }
        return (T)BeanFiller.fill(typeReference.getType(), null, null);
    }

    private static Object fill(Type type, Map<String, Type> superClassGenericTypes, Type superType) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type.equals(superType)) {
            return null;
        }
        return new BeanFiller(type, superClassGenericTypes).doCreateJavaBean();
    }

    private void initGenericTypes(Map<String, Type> superClassGenericTypes) {
        if (this.type instanceof ParameterizedType) {
            int i;
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            Class clazz = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeVariables = clazz.getTypeParameters();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            for (i = 0; i < actualTypeArguments.length; ++i) {
                Type actualTypeArgument = actualTypeArguments[i];
                if (!(actualTypeArgument instanceof TypeVariable)) continue;
                if (superClassGenericTypes == null || (actualTypeArgument = superClassGenericTypes.get(this.getNameOfTypeVariable(actualTypeArgument))) == null) {
                    throw new RuntimeException();
                }
                actualTypeArguments[i] = actualTypeArgument;
            }
            for (i = 0; i < typeVariables.length; ++i) {
                this.genericTypes.put(this.getNameOfTypeVariable(typeVariables[i]), actualTypeArguments[i]);
            }
        }
    }

    private String getNameOfTypeVariable(Type typeVariable) {
        return ((TypeVariable)typeVariable).getName();
    }

    private Object doCreateJavaBean() {
        if (this.type instanceof Class) {
            return this.createJavaBeanWithClass((Class)this.type);
        }
        if (this.type instanceof ParameterizedType) {
            return this.createJavaBeanWithGenericType((ParameterizedType)this.type);
        }
        throw new UnsupportedOperationException("unsupported type: " + this.type);
    }

    private Object createJavaBeanWithClass(Class<?> clazz) {
        if (DEFAULT_VALUE_OF_BASIC_CLASS.containsKey(clazz)) {
            return DEFAULT_VALUE_OF_BASIC_CLASS.get(clazz);
        }
        if (String.class.equals(clazz)) {
            return STRING_DEFAULT_VALUE;
        }
        Object obj = this.createInstance(clazz);
        for (Method setMethod : this.getSetMethods(clazz)) {
            Type paramType = setMethod.getGenericParameterTypes()[0];
            this.setDefaultValue(obj, setMethod, paramType);
        }
        return obj;
    }

    private Object createJavaBeanWithGenericType(ParameterizedType type) {
        Class clazz = (Class)type.getRawType();
        Object obj = this.createInstance(clazz);
        for (Method setMethod : this.getSetMethods(clazz)) {
            Type paramType = setMethod.getGenericParameterTypes()[0];
            if (paramType instanceof TypeVariable) {
                Type actualType = this.genericTypes.get(this.getNameOfTypeVariable(paramType));
                this.setDefaultValue(obj, setMethod, actualType);
                continue;
            }
            this.setDefaultValue(obj, setMethod, paramType);
        }
        return obj;
    }

    private Object createInstance(Class<?> clazz) {
        Object obj;
        try {
            obj = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot instantiate without no args constructor");
        }
        return obj;
    }

    private List<Method> getSetMethods(Class<?> clazz) {
        Method[] methods;
        ArrayList<Method> setMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().startsWith(SET_METHOD_PREFIX) || !SET_METHOD_PARAM_COUNT.equals(method.getParameterCount()) || !SET_METHOD_RETURN_TYPE.equals(method.getReturnType())) continue;
            setMethods.add(method);
        }
        return setMethods;
    }

    private void setDefaultValue(Object obj, Method method, Type paramType) {
        block4: {
            try {
                if (paramType instanceof Class) {
                    this.setDefaultValueOfNormal(obj, method, (Class)paramType);
                    break block4;
                }
                if (paramType instanceof ParameterizedType) {
                    this.setDefaultValueOfGeneric(obj, method, (ParameterizedType)paramType);
                    break block4;
                }
                throw new UnsupportedOperationException();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException();
            }
        }
    }

    private String getFieldName(Method method) {
        return method.getName().substring(3);
    }

    private void setDefaultValueOfNormal(Object obj, Method method, Class<?> paramClass) throws IllegalAccessException, InvocationTargetException {
        if (DEFAULT_VALUE_OF_BASIC_CLASS.containsKey(paramClass)) {
            method.invoke(obj, DEFAULT_VALUE_OF_BASIC_CLASS.get(paramClass));
        } else if (String.class.equals(paramClass)) {
            method.invoke(obj, STRING_DEFAULT_VALUE + this.getFieldName(method));
        } else {
            method.invoke(obj, BeanFiller.fill(paramClass, this.genericTypes, this.type));
        }
    }

    private void setDefaultValueOfGeneric(Object obj, Method method, ParameterizedType paramType) throws IllegalAccessException, InvocationTargetException {
        Class clazz = (Class)paramType.getRawType();
        if (this.instanceOfContainer(clazz)) {
            this.setDefaultValueForContainer(obj, method, paramType);
        } else {
            method.invoke(obj, BeanFiller.fill(paramType, this.genericTypes, this.type));
        }
    }

    private boolean instanceOfContainer(Class<?> clazz) {
        return CONTAINER_CLASS_SET.contains(clazz);
    }

    private void setDefaultValueForContainer(Object obj, Method method, ParameterizedType paramType) throws IllegalAccessException, InvocationTargetException {
        Class clazz = (Class)paramType.getRawType();
        if (List.class.equals((Object)clazz)) {
            ArrayList<Object> list = new ArrayList<Object>();
            Type genericParam = paramType.getActualTypeArguments()[0];
            for (int i = 0; i < CONTAINER_DEFAULT_SIZE; ++i) {
                list.add(this.createJavaBeanWithTypeVariable(genericParam));
            }
            method.invoke(obj, list);
        } else if (Set.class.equals((Object)clazz)) {
            HashSet<Object> set = new HashSet<Object>();
            Type genericParam = paramType.getActualTypeArguments()[0];
            for (int i = 0; i < CONTAINER_DEFAULT_SIZE; ++i) {
                set.add(this.createJavaBeanWithTypeVariable(genericParam));
            }
            method.invoke(obj, set);
        } else if (Queue.class.equals((Object)clazz)) {
            LinkedList<Object> queue = new LinkedList<Object>();
            Type genericParam = paramType.getActualTypeArguments()[0];
            for (int i = 0; i < CONTAINER_DEFAULT_SIZE; ++i) {
                queue.add(this.createJavaBeanWithTypeVariable(genericParam));
            }
            method.invoke(obj, queue);
        } else if (Map.class.equals((Object)clazz)) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Type genericParam1 = paramType.getActualTypeArguments()[0];
            Type genericParam2 = paramType.getActualTypeArguments()[1];
            for (int i = 0; i < CONTAINER_DEFAULT_SIZE; ++i) {
                Object key = this.createJavaBeanWithTypeVariable(genericParam1);
                Object value = this.createJavaBeanWithTypeVariable(genericParam2);
                map.put(key, value);
            }
            method.invoke(obj, map);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private Object createJavaBeanWithTypeVariable(Type type) {
        if (type instanceof TypeVariable) {
            return BeanFiller.fill(this.genericTypes.get(this.getNameOfTypeVariable(type)), this.genericTypes, this.type);
        }
        return BeanFiller.fill(type, this.genericTypes, this.type);
    }

    static {
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Byte.class, BYTE_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Byte.TYPE, BYTE_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Character.class, CHAR_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Character.TYPE, CHAR_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Short.class, SHORT_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Short.TYPE, SHORT_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Integer.class, INTEGER_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Integer.TYPE, INTEGER_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Long.class, LONG_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Long.TYPE, LONG_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Float.class, FLOAT_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Float.TYPE, FLOAT_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Double.class, DOUBLE_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Double.TYPE, DOUBLE_DEFAULT_VALUE);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Boolean.class, false);
        DEFAULT_VALUE_OF_BASIC_CLASS.put(Boolean.TYPE, false);
        CONTAINER_CLASS_SET.add(List.class);
        CONTAINER_CLASS_SET.add(Map.class);
        CONTAINER_CLASS_SET.add(Set.class);
        CONTAINER_CLASS_SET.add(Queue.class);
    }

    public static abstract class TypeReference<T> {
        private final Type type;

        protected TypeReference() {
            Type superClass = this.getClass().getGenericSuperclass();
            this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        }

        public final Type getType() {
            return this.type;
        }
    }
}

