/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.collection;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public abstract class SplitUtils {
    public static <T> List<List<T>> split(List<T> list, int segmentSize) {
        Assert.assertNotNull(list);
        Assert.assertTrue(segmentSize > 0);
        ArrayList segments = Lists.newArrayList();
        int left = 0;
        int right = Math.min(segmentSize, list.size());
        while (right < list.size()) {
            ArrayList segment = Lists.newArrayList(list.subList(left, right));
            left = right;
            right = right + segmentSize < list.size() ? (right += segmentSize) : list.size();
            segments.add(segment);
        }
        segments.add(Lists.newArrayList(list.subList(left, right)));
        return segments;
    }
}

