/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.io.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.ReferenceCountUtil;

public class ConvertUtils {
    public static ByteBuf convertRequest2ByteBuf(FullHttpRequest msg, boolean needRetain) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestEncoder()});
        return ConvertUtils.convert2ByteBuf(ch, (ByteBufHolder)msg, needRetain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertRequest2Bytes(FullHttpRequest msg, boolean needRetain) {
        ByteBuf byteBuf = ConvertUtils.convertRequest2ByteBuf(msg, needRetain);
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            return byArray;
        }
        finally {
            ReferenceCountUtil.release((Object)byteBuf);
        }
    }

    public static ByteBuf convertResponse2ByteBuf(FullHttpResponse msg, boolean needRetain) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        return ConvertUtils.convert2ByteBuf(ch, (ByteBufHolder)msg, needRetain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertResponse2Bytes(FullHttpResponse msg, boolean needRetain) {
        ByteBuf byteBuf = ConvertUtils.convertResponse2ByteBuf(msg, needRetain);
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            return byArray;
        }
        finally {
            ReferenceCountUtil.release((Object)byteBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf convert2ByteBuf(EmbeddedChannel ch, ByteBufHolder msg, boolean needRetain) {
        ByteBuf cache = Unpooled.buffer();
        try {
            ByteBuf byteBuf;
            if (needRetain) {
                ch.writeOutbound(new Object[]{msg.retain()});
            } else {
                ch.writeOutbound(new Object[]{msg});
            }
            while ((byteBuf = (ByteBuf)ch.readOutbound()) != null) {
                try {
                    cache.writeBytes(byteBuf);
                }
                finally {
                    ReferenceCountUtil.release((Object)byteBuf);
                }
            }
            ByteBuf byteBuf2 = cache;
            return byteBuf2;
        }
        finally {
            ch.close();
        }
    }
}

