/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.io.netty;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import io.netty.buffer.ByteBuf;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.ReferenceCountUtil;

public abstract class Converter<T1, T2, T3, T4> {
    protected final EmbeddedChannel channel = new EmbeddedChannel();

    protected Converter() {
    }

    public final void writeOutbound(T3 msg, Consumer<T2> inboundConsumer, Consumer<T4> outboundConsumer) {
        this.channel.writeOneOutbound(msg).addListener(future -> {
            if (!future.isSuccess()) {
                ReferenceCountUtil.release((Object)msg);
            }
        });
        this.channel.flushOutbound();
        this.callBothConsumersIfNecessary(inboundConsumer, outboundConsumer);
    }

    public final void writeInbound(T1 msg, Consumer<T2> inboundConsumer, Consumer<T4> outboundConsumer) {
        this.channel.writeOneInbound(msg).addListener(future -> {
            if (!future.isSuccess()) {
                ReferenceCountUtil.release((Object)msg);
            }
        });
        this.channel.flushInbound();
        this.callBothConsumersIfNecessary(inboundConsumer, outboundConsumer);
    }

    public void close() {
        this.channel.finishAndReleaseAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callBothConsumersIfNecessary(Consumer<T2> inboundConsumer, Consumer<T4> outboundConsumer) {
        T4 outboundData;
        T2 inboundData;
        while ((inboundData = this.readInbound()) != null) {
            try {
                if (inboundConsumer == null) continue;
                inboundConsumer.consume(inboundData);
            }
            finally {
                ReferenceCountUtil.release(inboundData);
            }
        }
        while ((outboundData = this.readOutbound()) != null) {
            try {
                if (outboundConsumer == null) continue;
                outboundConsumer.consume(outboundData);
            }
            finally {
                ReferenceCountUtil.release(outboundData);
            }
        }
    }

    private T2 readInbound() {
        return (T2)this.channel.readInbound();
    }

    private T4 readOutbound() {
        return (T4)this.channel.readOutbound();
    }

    public static abstract class ByteBufConsumer
    implements Consumer<ByteBuf> {
        private final int maxSegmentSize;

        public ByteBufConsumer(int maxSegmentSize) {
            Assert.assertTrue(maxSegmentSize > 0, "maxSegmentSize must be positive");
            this.maxSegmentSize = maxSegmentSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(ByteBuf data) {
            int index = 0;
            while (data.readableBytes() > 0) {
                int readNum = Math.min(data.readableBytes(), this.maxSegmentSize);
                ByteBuf segment = data.readBytes(readNum);
                try {
                    this.consumeSegment(index++, segment);
                }
                finally {
                    ReferenceCountUtil.release((Object)segment);
                }
            }
        }

        protected abstract void consumeSegment(int var1, ByteBuf var2);
    }

    @FunctionalInterface
    public static interface Consumer<I> {
        public void consume(I var1);
    }
}

