/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.io.ssl;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.common.tools.bean.OptionalUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import sun.security.tools.keytool.CertAndKeyGen;

public class KeyStoreUtils {
    public static final String DEFAULT_KEY_STORE_TYPE = "PKCS12";
    public static final String DEFAULT_ENCRYPT_ALGORITHM = "RSA";
    public static final String DEFAULT_HASH_ALGORITHM = "SHA1WithRSA";
    public static final int DEFAULT_KEY_LENGTH = 2048;
    public static final String DEFAULT_SUBJECT_NAME = "CN=ROOT";
    public static final long DEFAULT_VALIDATION = 31536000L;
    public static final String DEFAULT_KEY_ALIAS = "ROOT";
    public static final String DEFAULT_KEY_PASSWORD = "123456";
    private static final String CERTIFICATE_TYPE = "X509";

    public static KeyStore createKeyStoreContainingSelfSignedCertWithSunLib(String keyStoreType, String encryptAlgorithm, String hashAlgorithm, Integer keyLength, String subjectName, Long validation, String keyAlias, String keyPassword) {
        keyStoreType = OptionalUtils.getOrDefault(keyStoreType, DEFAULT_KEY_STORE_TYPE);
        encryptAlgorithm = OptionalUtils.getOrDefault(encryptAlgorithm, DEFAULT_ENCRYPT_ALGORITHM);
        hashAlgorithm = OptionalUtils.getOrDefault(hashAlgorithm, DEFAULT_HASH_ALGORITHM);
        keyLength = OptionalUtils.getOrDefault(keyLength, 2048);
        subjectName = OptionalUtils.getOrDefault(subjectName, DEFAULT_SUBJECT_NAME);
        validation = OptionalUtils.getOrDefault(validation, 31536000L);
        keyAlias = OptionalUtils.getOrDefault(keyAlias, DEFAULT_KEY_ALIAS);
        keyPassword = OptionalUtils.getOrDefault(keyPassword, DEFAULT_KEY_PASSWORD);
        try {
            KeyStore keyStore = KeyStoreUtils.createKeyStore(keyStoreType);
            CertAndKeyGen gen = new CertAndKeyGen(encryptAlgorithm, hashAlgorithm);
            gen.generate(keyLength);
            PrivateKey privateKey = gen.getPrivateKey();
            X509Certificate cert = gen.getSelfCertificate(new sun.security.x509.X500Name(subjectName), validation);
            keyStore.setKeyEntry(keyAlias, privateKey, keyPassword.toCharArray(), new X509Certificate[]{cert});
            return keyStore;
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore createKeyStoreContainingSelfSignedCertWithBouncyCastleLib(String keyStoreType, String encryptAlgorithm, String hashAlgorithm, Integer keyLength, String subjectName, Long validation, String keyAlias, String keyPassword) {
        keyStoreType = OptionalUtils.getOrDefault(keyStoreType, DEFAULT_KEY_STORE_TYPE);
        encryptAlgorithm = OptionalUtils.getOrDefault(encryptAlgorithm, DEFAULT_ENCRYPT_ALGORITHM);
        hashAlgorithm = OptionalUtils.getOrDefault(hashAlgorithm, DEFAULT_HASH_ALGORITHM);
        keyLength = OptionalUtils.getOrDefault(keyLength, 2048);
        subjectName = OptionalUtils.getOrDefault(subjectName, DEFAULT_SUBJECT_NAME);
        validation = OptionalUtils.getOrDefault(validation, 31536000L);
        keyAlias = OptionalUtils.getOrDefault(keyAlias, DEFAULT_KEY_ALIAS);
        keyPassword = OptionalUtils.getOrDefault(keyPassword, DEFAULT_KEY_PASSWORD);
        try {
            KeyStore keyStore = KeyStoreUtils.createKeyStore(keyStoreType);
            KeyPair keyPair = KeyStoreUtils.createKeyPair(encryptAlgorithm, keyLength);
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            X509Certificate cert = KeyStoreUtils.x509SelfSign(privateKey, publicKey, subjectName, hashAlgorithm, validation);
            keyStore.setKeyEntry(keyAlias, privateKey, keyPassword.toCharArray(), new X509Certificate[]{cert});
            return keyStore;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore createKeyStore(String keyStoreType) {
        keyStoreType = OptionalUtils.getOrDefault(keyStoreType, DEFAULT_KEY_STORE_TYPE);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, null);
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException();
        }
    }

    public static KeyPair createKeyPair(String encryptAlgorithm, Integer keyLength) {
        encryptAlgorithm = OptionalUtils.getOrDefault(encryptAlgorithm, DEFAULT_ENCRYPT_ALGORITHM);
        keyLength = OptionalUtils.getOrDefault(keyLength, 2048);
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(encryptAlgorithm);
            keyPairGenerator.initialize(keyLength);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate x509Sign(PrivateKey rootPrivateKey, X509Certificate rootCert, PublicKey publicKey, String subjectName, String hashAlgorithm, Long validation) {
        Assert.assertNotNull((Object)rootCert, "rootCert");
        subjectName = OptionalUtils.getOrDefault(subjectName, DEFAULT_SUBJECT_NAME);
        hashAlgorithm = OptionalUtils.getOrDefault(hashAlgorithm, DEFAULT_HASH_ALGORITHM);
        validation = OptionalUtils.getOrDefault(validation, 31536000L);
        return KeyStoreUtils.x509Sign(rootPrivateKey, rootCert.getSubjectDN().getName(), publicKey, subjectName, hashAlgorithm, validation);
    }

    public static X509Certificate x509SelfSign(PrivateKey privateKey, PublicKey publicKey, String subjectName, String hashAlgorithm, Long validation) {
        subjectName = OptionalUtils.getOrDefault(subjectName, DEFAULT_SUBJECT_NAME);
        hashAlgorithm = OptionalUtils.getOrDefault(hashAlgorithm, DEFAULT_HASH_ALGORITHM);
        validation = OptionalUtils.getOrDefault(validation, 31536000L);
        return KeyStoreUtils.x509Sign(privateKey, subjectName, publicKey, subjectName, hashAlgorithm, validation);
    }

    private static X509Certificate x509Sign(PrivateKey rootPrivateKey, String rootSubjectName, PublicKey publicKey, String subjectName, String hashAlgorithm, Long validation) {
        Assert.assertNotNull((Object)rootPrivateKey, "rootPrivateKey");
        Assert.assertNotNull((Object)rootSubjectName, "rootSubjectName");
        Assert.assertNotNull((Object)publicKey, "publicKey");
        Assert.assertNotNull((Object)subjectName, "subjectName");
        Assert.assertNotNull((Object)hashAlgorithm, "hashAlgorithm");
        Assert.assertNotNull((Object)validation, "validation");
        try {
            X500Name issuer = new X500Name(rootSubjectName);
            X500Name subject = new X500Name(subjectName);
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(publicKey.getEncoded()).readObject());
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(issuer, BigInteger.valueOf(System.currentTimeMillis()), new Date(), new Date(System.currentTimeMillis() + 1000L * validation), subject, subjectPublicKeyInfo);
            ContentSigner sigGen = new JcaContentSignerBuilder(hashAlgorithm).build(rootPrivateKey);
            X509CertificateHolder holder = certificateBuilder.build(sigGen);
            return (X509Certificate)CertificateFactory.getInstance(CERTIFICATE_TYPE).generateCertificate(new ByteArrayInputStream(holder.getEncoded()));
        }
        catch (IOException | CertificateException | OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }
}

