/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.common.tools.number;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import java.util.Collection;

public abstract class NumberUtils {
    public static final long THOUSAND = 1000L;
    public static final long MILLION = 1000000L;
    public static final long BILLION = 1000000000L;
    public static final long TRILLION = 1000000000000L;
    public static final long K = 1024L;
    public static final long M = 0x100000L;
    public static final long G = 0x40000000L;
    public static final long T = 0x10000000000L;

    public static int majorityOf(int totalNum) {
        Assert.assertTrue(totalNum > 0, "totalNum");
        return (totalNum >> 1) + 1;
    }

    public static int minorityOf(int totalNum) {
        return totalNum - NumberUtils.majorityOf(totalNum);
    }

    public static int subMajorityOf(int totalNum) {
        Assert.assertTrue(totalNum > 0, "totalNum");
        return totalNum + 1 >> 1;
    }

    public static double average(Collection<? extends Number> numbers) {
        Assert.assertNotNull(numbers, "numbers");
        double total = 0.0;
        for (Number number : numbers) {
            Assert.assertNotNull((Object)number, "number");
            total += number.doubleValue();
        }
        return total / (double)numbers.size();
    }

    public static double standardDeviation(Collection<? extends Number> numbers, double average) {
        Assert.assertNotNull(numbers, "numbers");
        double total = 0.0;
        for (Number number : numbers) {
            Assert.assertNotNull((Object)number, "number");
            double diff = number.doubleValue() - average;
            total += diff * diff;
        }
        return Math.sqrt(total / (double)numbers.size());
    }

    public static double standardDeviation(Collection<? extends Number> numbers) {
        return NumberUtils.standardDeviation(numbers, NumberUtils.average(numbers));
    }
}

