/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.expression.engine.Option;
import com.github.liuyehcf.framework.expression.engine.compile.ExpressionCompiler;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.function.DelegateOperatorFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.Function;
import com.github.liuyehcf.framework.expression.engine.core.function.OperatorFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.collection.CollectionIncludeFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.collection.CollectionSizeFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.date.DateTimestampFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathAbsFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathCosFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathLog10Function;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathLogFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathMaxFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathMinFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathPowFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathRandDoubleFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathRandLongFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathSinFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathSqrtFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.math.MathTanFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.add.AddOperatorFunctionForDouble;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.add.AddOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.add.AddOperatorFunctionForString;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.bitand.BitAndOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.bitor.BitOrOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.bitxor.BitXorOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.cmp.CmpOperatorFunctionForComparableObject;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.cmp.CmpOperatorFunctionForDouble;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.cmp.CmpOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.cmp.CmpOperatorFunctionForString;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.div.DivOperatorFunctionForDouble;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.div.DivOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.mul.MulOperatorFunctionForDouble;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.mul.MulOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.neg.NegOperatorFunctionForDouble;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.neg.NegOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.rem.RemOperatorFunctionForDouble;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.rem.RemOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.shl.ShlOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.shr.ShrOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.sub.SubOperatorFunctionForDouble;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.sub.SubOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.operator.ushr.UshrOperatorFunctionForLong;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringEndsWithFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringIndexOfFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringJoinFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringLengthFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringReplaceAllFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringReplaceFirstFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringSplitFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringStartsWithFunction;
import com.github.liuyehcf.framework.expression.engine.core.function.string.StringSubStringFunction;
import com.github.liuyehcf.framework.expression.engine.core.model.OperatorType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public abstract class ExpressionEngine {
    private static final ExpressionCompiler EXPRESSION_COMPILER = ExpressionCompiler.getInstance();
    private static final Map<String, Function> NORMAL_FUNCTIONS = Maps.newHashMap();
    private static final Map<OperatorType, List<OperatorFunction>> OPERATOR_FUNCTIONS = Maps.newHashMap();
    private static final Map<Option, Boolean> OPTIONS = Maps.newHashMap();

    private static void loadLib() {
        ExpressionEngine.addFunction(new CollectionIncludeFunction());
        ExpressionEngine.addFunction(new CollectionSizeFunction());
        ExpressionEngine.addFunction(new DateTimestampFunction());
        ExpressionEngine.addFunction(new MathAbsFunction());
        ExpressionEngine.addFunction(new MathCosFunction());
        ExpressionEngine.addFunction(new MathLog10Function());
        ExpressionEngine.addFunction(new MathLogFunction());
        ExpressionEngine.addFunction(new MathMaxFunction());
        ExpressionEngine.addFunction(new MathMinFunction());
        ExpressionEngine.addFunction(new MathPowFunction());
        ExpressionEngine.addFunction(new MathRandDoubleFunction());
        ExpressionEngine.addFunction(new MathRandLongFunction());
        ExpressionEngine.addFunction(new MathSinFunction());
        ExpressionEngine.addFunction(new MathSqrtFunction());
        ExpressionEngine.addFunction(new MathTanFunction());
        ExpressionEngine.addFunction(new StringEndsWithFunction());
        ExpressionEngine.addFunction(new StringIndexOfFunction());
        ExpressionEngine.addFunction(new StringJoinFunction());
        ExpressionEngine.addFunction(new StringLengthFunction());
        ExpressionEngine.addFunction(new StringReplaceAllFunction());
        ExpressionEngine.addFunction(new StringReplaceFirstFunction());
        ExpressionEngine.addFunction(new StringSplitFunction());
        ExpressionEngine.addFunction(new StringStartsWithFunction());
        ExpressionEngine.addFunction(new StringSubStringFunction());
        for (OperatorType value : OperatorType.values()) {
            OPERATOR_FUNCTIONS.put(value, Lists.newArrayList());
        }
        ExpressionEngine.addOperatorFunction(new AddOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new AddOperatorFunctionForDouble());
        ExpressionEngine.addOperatorFunction(new AddOperatorFunctionForString());
        ExpressionEngine.addOperatorFunction(new BitAndOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new BitOrOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new BitXorOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new CmpOperatorFunctionForComparableObject());
        ExpressionEngine.addOperatorFunction(new CmpOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new CmpOperatorFunctionForDouble());
        ExpressionEngine.addOperatorFunction(new CmpOperatorFunctionForString());
        ExpressionEngine.addOperatorFunction(new DivOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new DivOperatorFunctionForDouble());
        ExpressionEngine.addOperatorFunction(new MulOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new MulOperatorFunctionForDouble());
        ExpressionEngine.addOperatorFunction(new NegOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new NegOperatorFunctionForDouble());
        ExpressionEngine.addOperatorFunction(new RemOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new RemOperatorFunctionForDouble());
        ExpressionEngine.addOperatorFunction(new ShlOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new ShrOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new SubOperatorFunctionForLong());
        ExpressionEngine.addOperatorFunction(new SubOperatorFunctionForDouble());
        ExpressionEngine.addOperatorFunction(new UshrOperatorFunctionForLong());
    }

    private static void initOption() {
        for (Option value : Option.values()) {
            OPTIONS.put(value, true);
        }
    }

    public static synchronized void setOption(Option option, boolean status) {
        OPTIONS.put(option, status);
    }

    public static boolean getOption(Option option) {
        return OPTIONS.get((Object)option);
    }

    public static Map<Option, Boolean> getOptions() {
        return OPTIONS;
    }

    public static synchronized void addFunction(Function function) {
        String functionName = function.getName();
        if (NORMAL_FUNCTIONS.containsKey(functionName)) {
            throw new ExpressionException("duplicate function '" + functionName + "'");
        }
        NORMAL_FUNCTIONS.put(functionName, function);
    }

    public static synchronized Function removeFunction(String functionName) {
        return NORMAL_FUNCTIONS.remove(functionName);
    }

    public static Function getFunction(String functionName) {
        return NORMAL_FUNCTIONS.get(functionName);
    }

    public static synchronized void cleanOperatorFunctions(OperatorType type) {
        OPERATOR_FUNCTIONS.get((Object)type).clear();
    }

    public static synchronized void cleanOperatorFunctions() {
        for (OperatorType type : OperatorType.values()) {
            ExpressionEngine.cleanOperatorFunctions(type);
        }
    }

    public static synchronized String addOperatorFunction(OperatorFunction function) {
        Assert.assertNotNull((Object)function);
        OperatorType type = function.getType();
        String id = UUID.randomUUID().toString();
        OPERATOR_FUNCTIONS.get((Object)type).add(new DelegateOperatorFunction(id, function));
        Collections.sort(OPERATOR_FUNCTIONS.get((Object)type));
        return id;
    }

    public static synchronized Function removeOperatorFunction(OperatorType type, String id) {
        Iterator<OperatorFunction> iterator = OPERATOR_FUNCTIONS.get((Object)type).iterator();
        while (iterator.hasNext()) {
            DelegateOperatorFunction next = (DelegateOperatorFunction)iterator.next();
            if (!Objects.equals(next.getId(), id)) continue;
            iterator.remove();
            return next;
        }
        return null;
    }

    public static List<OperatorFunction> getOperatorFunctions(OperatorType type) {
        return OPERATOR_FUNCTIONS.get((Object)type);
    }

    public static ExpressionCode compile(String expression) {
        return EXPRESSION_COMPILER.parse(expression);
    }

    public static <T> T execute(String expression, Map<String, Object> env) {
        return ExpressionEngine.execute(ExpressionEngine.compile(expression), env);
    }

    public static <T> T execute(String expression) {
        return ExpressionEngine.execute(expression, null);
    }

    public static <T> T execute(ExpressionCode expressionCode, Map<String, Object> env) {
        return expressionCode.execute(env);
    }

    public static <T> T execute(ExpressionCode expressionCode) {
        return ExpressionEngine.execute(expressionCode, null);
    }

    public static <T> T exec(String expression, Object ... properties) {
        return ExpressionEngine.exec(ExpressionEngine.compile(expression), properties);
    }

    public static <T> T exec(ExpressionCode expressionCode, Object ... properties) {
        return expressionCode.exec(properties);
    }

    static {
        ExpressionEngine.loadLib();
        ExpressionEngine.initOption();
    }
}

