/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.compile.engine.cfg.lr.Context;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;

public class CompilerContext
extends Context {
    private final ExpressionCode expressionCode;

    public CompilerContext(Context context, ExpressionCode expressionCode) {
        super(context.getRawPrimaryProduction(), context.getStack(), context.getLeftNode());
        this.expressionCode = expressionCode;
    }

    public void setAttr(int stackOffset, AttrName attrName, Object value) {
        Assert.assertNotNull((Object)((Object)attrName));
        this.getStack().get(stackOffset).put(attrName.name(), value);
    }

    public void setAttrToLeftNode(AttrName attrName, Object value) {
        Assert.assertNotNull((Object)((Object)attrName));
        this.getLeftNode().put(attrName.name(), value);
    }

    public <T> T getAttr(int stackOffset, AttrName attrName) {
        Assert.assertNotNull((Object)((Object)attrName));
        return (T)this.getStack().get(stackOffset).get(attrName.name());
    }

    public String getValue(int stackOffset) {
        return this.getStack().get(stackOffset).getValue();
    }

    public void addByteCode(ByteCode byteCode) {
        this.expressionCode.addByteCode(byteCode);
    }

    public int getByteCodeSize() {
        return this.expressionCode.getByteCodes().size();
    }

    public void addProperty(String propertyName) {
        this.expressionCode.addPropertyName(propertyName);
    }
}

