/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.compile.engine.CompileResult;
import com.github.liuyehcf.framework.compile.engine.cfg.lr.AbstractLRCompiler;
import com.github.liuyehcf.framework.compile.engine.cfg.lr.Context;
import com.github.liuyehcf.framework.compile.engine.cfg.lr.LALR;
import com.github.liuyehcf.framework.compile.engine.grammar.definition.SemanticAction;
import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.GrammarDefinition;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.compile.optimize.OptimizerPipeline;
import com.github.liuyehcf.framework.expression.engine.compile.optimize.impl.ConstantExpressionOptimizer;
import com.github.liuyehcf.framework.expression.engine.compile.optimize.impl.ControlTransferOptimizer;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.utils.OptionUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;

public class ExpressionCompiler
extends LALR<ExpressionCode> {
    static final String COMPILER_SERIALIZATION_FILE = "EXPRESSION_COMPILER";
    private static final ExpressionCompiler INSTANCE = ExpressionCompiler.loadCompiler();
    private final Cache<String, ExpressionCode> byteCodeCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final OptimizerPipeline optimizerPipeline = OptimizerPipeline.builder().addOptimizer(new ConstantExpressionOptimizer()).addOptimizer(new ControlTransferOptimizer()).build();

    private ExpressionCompiler() {
        super(GrammarDefinition.GRAMMAR, GrammarDefinition.LEXICAL_ANALYZER);
    }

    private static ExpressionCompiler loadCompiler() {
        try {
            InputStream resourceStream = ClassLoader.getSystemClassLoader().getResourceAsStream(COMPILER_SERIALIZATION_FILE);
            Assert.assertNotNull((Object)resourceStream);
            ObjectInputStream inputStream = new ObjectInputStream(resourceStream);
            return (ExpressionCompiler)((Object)inputStream.readObject());
        }
        catch (Throwable throwable) {
            return new ExpressionCompiler();
        }
    }

    public static ExpressionCompiler getInstance() {
        return INSTANCE;
    }

    public final ExpressionCode parse(String expression) {
        if (OptionUtils.isCache()) {
            try {
                return (ExpressionCode)this.byteCodeCache.get((Object)expression, () -> this.doParse(expression));
            }
            catch (Throwable e) {
                Throwable cause;
                if (e instanceof UncheckedExecutionException && (cause = e.getCause()) instanceof ExpressionException) {
                    throw (ExpressionException)cause;
                }
                throw new ExpressionException("unexpected cache error", e);
            }
        }
        return this.doParse(expression);
    }

    private ExpressionCode doParse(String expression) {
        CompileResult compile = this.compile(expression);
        if (!compile.isSuccess()) {
            throw new ExpressionException(compile.getError().getMessage(), compile.getError());
        }
        return (ExpressionCode)compile.getResult();
    }

    protected AbstractLRCompiler.Engine createCompiler(String input) {
        return new HuaEngine(input);
    }

    public class HuaEngine
    extends AbstractLRCompiler.Engine {
        private ExpressionCode expressionCode;

        HuaEngine(String input) {
            super((AbstractLRCompiler)ExpressionCompiler.this, input);
            this.expressionCode = new ExpressionCode();
        }

        protected void before() {
        }

        protected void after() {
            this.optimize();
            this.setResult(this.expressionCode);
        }

        protected void onReduction(Context context) {
            List semanticActions = context.getRawPrimaryProduction().getSemanticActions();
            if (semanticActions == null) {
                return;
            }
            for (SemanticAction semanticAction : semanticActions) {
                ((AbstractSemanticAction)semanticAction).onAction(new CompilerContext(context, this.expressionCode));
            }
        }

        private void optimize() {
            if (!OptionUtils.isOptimize()) {
                return;
            }
            ExpressionCompiler.this.optimizerPipeline.optimize(this.expressionCode);
        }
    }
}

