/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.identifier;

import com.github.liuyehcf.framework.compile.engine.cfg.lexical.Token;
import com.github.liuyehcf.framework.compile.engine.cfg.lexical.TokenContext;
import com.github.liuyehcf.framework.compile.engine.cfg.lexical.identifier.TokenIdentifier;
import com.github.liuyehcf.framework.compile.engine.grammar.definition.Symbol;
import java.util.HashMap;
import java.util.Map;

public class ExpressionStringIdentifier
implements TokenIdentifier {
    private static final Map<Character, Integer> ESCAPE_CHARS = ExpressionStringIdentifier.initEscapeChars();

    private static Map<Character, Integer> initEscapeChars() {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        map.put(Character.valueOf('b'), 8);
        map.put(Character.valueOf('f'), 12);
        map.put(Character.valueOf('n'), 10);
        map.put(Character.valueOf('r'), 13);
        map.put(Character.valueOf('t'), 9);
        map.put(Character.valueOf('\\'), 92);
        map.put(Character.valueOf('\''), 39);
        map.put(Character.valueOf('\"'), 34);
        map.put(Character.valueOf('0'), 0);
        return map;
    }

    public Token identify(TokenContext tokenContext) {
        char quotation;
        Symbol id = tokenContext.getId();
        String remainInput = tokenContext.getRemainInput();
        if (0 < remainInput.length() && ((quotation = remainInput.charAt(0)) == '\"' || quotation == '\'')) {
            int i = 1;
            StringBuilder sb = new StringBuilder();
            sb.append(quotation);
            while (i < remainInput.length()) {
                if (remainInput.charAt(i) == '\\') {
                    if (i + 1 >= remainInput.length() || !ESCAPE_CHARS.containsKey(Character.valueOf(remainInput.charAt(i + 1)))) {
                        return null;
                    }
                    sb.append((char)ESCAPE_CHARS.get(Character.valueOf(remainInput.charAt(i + 1))).intValue());
                    i += 2;
                    continue;
                }
                if (remainInput.charAt(i) == quotation) {
                    sb.append(quotation);
                    tokenContext.setMoveLength(i + 1);
                    return new Token(id, sb.toString());
                }
                sb.append(remainInput.charAt(i));
                ++i;
            }
        }
        return null;
    }
}

