/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.model;

import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf.ConditionalControlTransfer;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf.ControlTransfer;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._goto;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifeq;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifge;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifgt;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifle;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._iflt;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifne;

public enum ControlTransferType {
    IFEQ,
    IFNE,
    IFGE,
    IFGT,
    IFLE,
    IFLT,
    GOTO;


    public static ControlTransfer getControlTransferByType(ControlTransferType type) {
        ControlTransfer controlTransfer;
        switch (type) {
            case IFEQ: {
                controlTransfer = new _ifeq();
                break;
            }
            case IFGE: {
                controlTransfer = new _ifge();
                break;
            }
            case IFGT: {
                controlTransfer = new _ifgt();
                break;
            }
            case IFLE: {
                controlTransfer = new _ifle();
                break;
            }
            case IFLT: {
                controlTransfer = new _iflt();
                break;
            }
            case IFNE: {
                controlTransfer = new _ifne();
                break;
            }
            case GOTO: {
                controlTransfer = new _goto();
                break;
            }
            default: {
                throw new ExpressionException("unexpected controlTransferType='" + (Object)((Object)type) + "'");
            }
        }
        return controlTransfer;
    }

    public static ControlTransfer getOppositeControlTransferByType(ControlTransferType type) {
        ConditionalControlTransfer controlTransfer;
        switch (type) {
            case IFEQ: {
                controlTransfer = new _ifne();
                break;
            }
            case IFGE: {
                controlTransfer = new _iflt();
                break;
            }
            case IFGT: {
                controlTransfer = new _ifle();
                break;
            }
            case IFLE: {
                controlTransfer = new _ifgt();
                break;
            }
            case IFLT: {
                controlTransfer = new _ifge();
                break;
            }
            case IFNE: {
                controlTransfer = new _ifeq();
                break;
            }
            default: {
                throw new ExpressionException("unexpected controlTransferType='" + (Object)((Object)type) + "'");
            }
        }
        return controlTransfer;
    }

    public ControlTransferType getOppositeType() {
        switch (this) {
            case IFLT: {
                return IFGE;
            }
            case IFLE: {
                return IFGT;
            }
            case IFGT: {
                return IFLE;
            }
            case IFGE: {
                return IFLT;
            }
            case IFNE: {
                return IFEQ;
            }
            case IFEQ: {
                return IFNE;
            }
        }
        throw new ExpressionException("unexpected controlTransferType='" + (Object)((Object)this) + "'");
    }
}

