/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.backfill;

import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.BackFillType;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf.ControlTransfer;
import java.util.List;

public class ControlTransferByteCodeBackFill
extends AbstractSemanticAction {
    private final int backFillStackOffset;
    private final BackFillType backFillType;

    public ControlTransferByteCodeBackFill(int backFillStackOffset, BackFillType backFillType) {
        this.backFillStackOffset = backFillStackOffset;
        this.backFillType = backFillType;
    }

    @Override
    public void onAction(CompilerContext context) {
        List controlTransfers;
        switch (this.backFillType) {
            case TRUE: {
                controlTransfers = (List)context.getAttr(this.backFillStackOffset, AttrName.TRUE_BYTE_CODE);
                break;
            }
            case FALSE: {
                controlTransfers = (List)context.getAttr(this.backFillStackOffset, AttrName.FALSE_BYTE_CODE);
                break;
            }
            case NEXT: {
                controlTransfers = (List)context.getAttr(this.backFillStackOffset, AttrName.NEXT_BYTE_CODE);
                break;
            }
            default: {
                throw new ExpressionException("unexpected backFillType='" + (Object)((Object)this.backFillType) + "'");
            }
        }
        if (controlTransfers != null) {
            for (ControlTransfer controlTransfer : controlTransfers) {
                controlTransfer.setCodeOffset(context.getByteCodeSize());
            }
            controlTransfers.clear();
        }
    }
}

