/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.code;

import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.BackFillType;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf.ControlTransfer;
import com.google.common.collect.Lists;
import java.util.List;

abstract class AbstractControlTransferByteCode
extends AbstractSemanticAction {
    private final int backFillStackOffset;
    private final BackFillType backFillType;

    AbstractControlTransferByteCode(int backFillStackOffset, BackFillType backFillType) {
        this.backFillStackOffset = backFillStackOffset;
        this.backFillType = backFillType;
    }

    void doAddCode(CompilerContext context, ControlTransfer code) {
        switch (this.backFillType) {
            case TRUE: {
                this.doAddCode(context, AttrName.TRUE_BYTE_CODE, code);
                break;
            }
            case FALSE: {
                this.doAddCode(context, AttrName.FALSE_BYTE_CODE, code);
                break;
            }
            case NEXT: {
                this.doAddCode(context, AttrName.NEXT_BYTE_CODE, code);
                break;
            }
            default: {
                throw new ExpressionException("unexpected backFillType='" + (Object)((Object)this.backFillType) + "'");
            }
        }
    }

    private void doAddCode(CompilerContext context, AttrName attrName, ControlTransfer code) {
        List controlTransfers = (List)context.getAttr(this.backFillStackOffset, attrName);
        if (controlTransfers == null) {
            controlTransfers = Lists.newArrayList();
            context.setAttr(this.backFillStackOffset, attrName, controlTransfers);
        }
        controlTransfers.add(code);
    }
}

