/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.code;

import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.google.common.collect.Lists;
import java.util.List;

public class MergeControlTransferByteCode
extends AbstractSemanticAction {
    private final int fromStackOffset;
    private final int toStackOffset;

    public MergeControlTransferByteCode(int fromStackOffset, int toStackOffset) {
        this.fromStackOffset = fromStackOffset;
        this.toStackOffset = toStackOffset;
    }

    @Override
    public void onAction(CompilerContext context) {
        this.doMerge(context, AttrName.TRUE_BYTE_CODE);
        this.doMerge(context, AttrName.FALSE_BYTE_CODE);
        this.doMerge(context, AttrName.NEXT_BYTE_CODE);
    }

    private void doMerge(CompilerContext context, AttrName attrName) {
        List fromCodes = (List)context.getAttr(this.fromStackOffset, attrName);
        List toCodes = (List)context.getAttr(this.toStackOffset, attrName);
        if (fromCodes == null) {
            return;
        }
        if (toCodes == null) {
            toCodes = Lists.newArrayList();
            context.setAttr(this.toStackOffset, attrName, toCodes);
        }
        toCodes.addAll(fromCodes);
    }
}

