/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.code;

import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._add;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._and;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._div;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._mul;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._or;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._rem;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._shl;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._shr;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._sub;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._ushr;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._xor;

public class PushBinaryComputeByteCode
extends AbstractSemanticAction {
    private final int operatorStackOffset;

    public PushBinaryComputeByteCode(int operatorStackOffset) {
        this.operatorStackOffset = operatorStackOffset;
    }

    @Override
    public void onAction(CompilerContext context) {
        String operator;
        switch (operator = context.getValue(this.operatorStackOffset)) {
            case "|": {
                context.addByteCode(new _or());
                break;
            }
            case "^": {
                context.addByteCode(new _xor());
                break;
            }
            case "&": {
                context.addByteCode(new _and());
                break;
            }
            case "<<": {
                context.addByteCode(new _shl());
                break;
            }
            case ">>": {
                context.addByteCode(new _shr());
                break;
            }
            case ">>>": {
                context.addByteCode(new _ushr());
                break;
            }
            case "+": {
                context.addByteCode(new _add());
                break;
            }
            case "-": {
                context.addByteCode(new _sub());
                break;
            }
            case "*": {
                context.addByteCode(new _mul());
                break;
            }
            case "/": {
                context.addByteCode(new _div());
                break;
            }
            case "%": {
                context.addByteCode(new _rem());
                break;
            }
            default: {
                throw new ExpressionException("unexpected operator='" + operator + "'");
            }
        }
    }
}

