/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.code;

import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.CompareOperatorType;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.ControlTransferType;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._cmp;

public class PushCompareTransferByteCode
extends AbstractSemanticAction {
    private final CompareOperatorType compareOperatorType;

    public PushCompareTransferByteCode(CompareOperatorType compareOperatorType) {
        this.compareOperatorType = compareOperatorType;
    }

    @Override
    public void onAction(CompilerContext context) {
        context.addByteCode(new _cmp());
        switch (this.compareOperatorType) {
            case EQUAL: {
                context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)ControlTransferType.IFNE);
                break;
            }
            case NOT_EQUAL: {
                context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)ControlTransferType.IFEQ);
                break;
            }
            case LESS_THAN: {
                context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)ControlTransferType.IFGE);
                break;
            }
            case LARGE_THEN: {
                context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)ControlTransferType.IFLE);
                break;
            }
            case LESS_EQUAL: {
                context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)ControlTransferType.IFGT);
                break;
            }
            case LARGE_EQUAL: {
                context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)ControlTransferType.IFLT);
                break;
            }
            default: {
                throw new ExpressionException("unexpected compareOperatorType='" + (Object)((Object)this.compareOperatorType) + "'");
            }
        }
    }
}

