/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.code;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.LiteralType;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._bconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._dconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._lconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._nconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._sconst;
import java.math.BigInteger;

public class PushConstByteCode
extends AbstractSemanticAction {
    private final int literalStackOffset;
    private final LiteralType literalType;

    public PushConstByteCode(int literalStackOffset, LiteralType literalType) {
        this.literalStackOffset = literalStackOffset;
        this.literalType = literalType;
    }

    @Override
    public void onAction(CompilerContext context) {
        String literal = (String)context.getAttr(this.literalStackOffset, AttrName.LITERAL_VALUE);
        switch (this.literalType) {
            case BOOLEAN: {
                Assert.assertTrue(("true".equals(literal) || "false".equals(literal) ? 1 : 0) != 0, (String)"[SYSTEM_ERROR] - Boolean literal parse error");
                context.addByteCode(new _bconst("true".equals(literal)));
                break;
            }
            case INTEGER: {
                BigInteger bigInteger;
                char firstChar = literal.charAt(0);
                switch (firstChar) {
                    case '1': {
                        if (literal.endsWith("l") || literal.endsWith("L")) {
                            BigInteger bigInteger2 = new BigInteger(literal.substring(1, literal.length() - 1), 10);
                            if (bigInteger2.bitLength() > 63) {
                                throw new ExpressionException("illegal integer literal='" + literal + "'");
                            }
                            context.addByteCode(new _lconst(bigInteger2.longValue()));
                            return;
                        }
                        bigInteger = new BigInteger(literal.substring(1), 10);
                        break;
                    }
                    case '2': {
                        bigInteger = new BigInteger(literal.substring(3), 16);
                        break;
                    }
                    case '3': {
                        bigInteger = new BigInteger(literal.substring(2), 8);
                        break;
                    }
                    default: {
                        throw new ExpressionException("lexer parsing integer literal error");
                    }
                }
                if (bigInteger.bitLength() < 64) {
                    context.addByteCode(new _lconst(bigInteger.longValue()));
                    break;
                }
                throw new ExpressionException("illegal integer literal='" + literal + "'");
            }
            case FLOAT: {
                double d = literal.endsWith("f") || literal.endsWith("F") || literal.endsWith("d") || literal.endsWith("D") ? Double.parseDouble(literal.substring(0, literal.length() - 1)) : Double.parseDouble(literal);
                if (Double.isInfinite(d)) {
                    throw new ExpressionException("illegal float literal='" + literal + "'");
                }
                context.addByteCode(new _dconst(d));
                break;
            }
            case STRING: {
                Assert.assertTrue((literal.length() >= 2 && (literal.charAt(0) == '\"' && literal.charAt(literal.length() - 1) == '\"' || literal.charAt(0) == '\'' && literal.charAt(literal.length() - 1) == '\'') ? 1 : 0) != 0, (String)"[SYSTEM_ERROR] - String literal parse error");
                String content = literal.substring(1, literal.length() - 1);
                context.addByteCode(new _sconst(content));
                break;
            }
            case NULL: {
                context.addByteCode(new _nconst());
                break;
            }
            default: {
                throw new ExpressionException("unexpected literalType='" + (Object)((Object)this.literalType) + "'");
            }
        }
    }
}

