/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.code;

import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.ControlTransferType;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._neg;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._xor;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._lconst;
import java.util.List;

public class PushUnaryComputeByteCode
extends AbstractSemanticAction {
    private final int operatorStackOffset;
    private final int rightStackOffset;

    public PushUnaryComputeByteCode(int operatorStackOffset, int rightStackOffset) {
        this.operatorStackOffset = operatorStackOffset;
        this.rightStackOffset = rightStackOffset;
    }

    @Override
    public void onAction(CompilerContext context) {
        String operator;
        switch (operator = context.getValue(this.operatorStackOffset)) {
            case "-": {
                context.addByteCode(new _neg());
                break;
            }
            case "+": {
                break;
            }
            case "~": {
                context.addByteCode(new _lconst(-1L));
                context.addByteCode(new _xor());
                break;
            }
            case "!": {
                ControlTransferType controlTransferType = (ControlTransferType)((Object)context.getAttr(this.rightStackOffset, AttrName.CONTROL_TRANSFER_TYPE));
                context.setAttrToLeftNode(AttrName.IS_COMPLEX_BOOLEAN_EXPRESSION, "NOT_NULL");
                if (controlTransferType == null) {
                    context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)ControlTransferType.IFNE);
                    break;
                }
                ControlTransferType oppositeType = controlTransferType.getOppositeType();
                context.setAttrToLeftNode(AttrName.CONTROL_TRANSFER_TYPE, (Object)oppositeType);
                List trueByteCodes = (List)context.getAttr(this.rightStackOffset, AttrName.TRUE_BYTE_CODE);
                List falseByteCodes = (List)context.getAttr(this.rightStackOffset, AttrName.FALSE_BYTE_CODE);
                context.setAttrToLeftNode(AttrName.TRUE_BYTE_CODE, falseByteCodes);
                context.setAttrToLeftNode(AttrName.FALSE_BYTE_CODE, trueByteCodes);
                break;
            }
            default: {
                throw new ExpressionException("unexpected operator='" + operator + "'");
            }
        }
    }
}

