/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.function;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.expression.engine.compile.CompilerContext;
import com.github.liuyehcf.framework.expression.engine.compile.definition.model.AttrName;
import com.github.liuyehcf.framework.expression.engine.compile.definition.semantic.AbstractSemanticAction;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ir._invokestatic;
import com.github.liuyehcf.framework.expression.engine.core.function.Function;
import com.github.liuyehcf.framework.expression.engine.utils.FunctionUtils;

public class FunctionInvocation
extends AbstractSemanticAction {
    private final int functionNameStackOffset;
    private final int argumentListStackOffset;

    public FunctionInvocation(int functionNameStackOffset, int argumentListStackOffset) {
        this.functionNameStackOffset = functionNameStackOffset;
        this.argumentListStackOffset = argumentListStackOffset;
    }

    @Override
    public void onAction(CompilerContext context) {
        String methodName = (String)context.getAttr(this.functionNameStackOffset, AttrName.METHOD_NAME);
        int argSize = (Integer)context.getAttr(this.argumentListStackOffset, AttrName.ARGUMENT_SIZE);
        Function function = FunctionUtils.getFunctionByName(methodName);
        Assert.assertNotNull((Object)function, (String)("[SYNTAX_ERROR] - Function '" + methodName + "' undefined"));
        context.addByteCode(new _invokestatic(methodName, argSize));
    }
}

