/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.optimize;

import com.github.liuyehcf.framework.expression.engine.compile.optimize.Optimizer;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public class OptimizerPipeline
implements Optimizer {
    private final List<Optimizer> optimizers;

    private OptimizerPipeline(List<Optimizer> optimizers) {
        this.optimizers = Collections.unmodifiableList(optimizers);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void optimize(ExpressionCode expressionCode) {
        for (Optimizer optimizer : this.optimizers) {
            optimizer.optimize(expressionCode);
        }
    }

    public static final class Builder {
        private final List<Optimizer> optimizers = Lists.newArrayList();

        private Builder() {
        }

        public Builder addOptimizer(Optimizer optimizer) {
            this.optimizers.add(optimizer);
            return this;
        }

        public OptimizerPipeline build() {
            return new OptimizerPipeline(this.optimizers);
        }
    }
}

