/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.optimize.impl;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.compile.engine.utils.Pair;
import com.github.liuyehcf.framework.expression.engine.compile.optimize.Optimizer;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf.ControlTransfer;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp.Compute;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl.Const;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._bconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._cconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._dconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._lconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._nconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._sconst;
import com.github.liuyehcf.framework.expression.engine.core.model.ComparableValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class ConstantExpressionOptimizer
implements Optimizer {
    @Override
    public void optimize(ExpressionCode expressionCode) {
        List<BasicBlock> basicBlocks = this.splitCodesToBasicBlocks(expressionCode);
        for (BasicBlock basicBlock : basicBlocks) {
            this.constantOptimization(basicBlock);
        }
        List<ByteCode> optimizedCodes = this.joinBasicBlocksToByteCodes(basicBlocks);
        expressionCode.setByteCodes(optimizedCodes);
    }

    private List<BasicBlock> splitCodesToBasicBlocks(ExpressionCode expressionCode) {
        int codeOffset;
        ByteCode byteCode;
        int i;
        List<Object> startCodeOffsets = Lists.newArrayList();
        startCodeOffsets.add(0);
        for (i = 0; i < expressionCode.getByteCodes().size(); ++i) {
            byteCode = expressionCode.getByteCodes().get(i);
            if (!(byteCode instanceof ControlTransfer)) continue;
            codeOffset = ((ControlTransfer)byteCode).getCodeOffset();
            startCodeOffsets.add(codeOffset);
            if (i + 1 >= expressionCode.getByteCodes().size()) continue;
            startCodeOffsets.add(i + 1);
        }
        startCodeOffsets = startCodeOffsets.stream().distinct().collect(Collectors.toList());
        Collections.sort(startCodeOffsets);
        for (i = 0; i < expressionCode.getByteCodes().size(); ++i) {
            byteCode = expressionCode.getByteCodes().get(i);
            if (!(byteCode instanceof ControlTransfer)) continue;
            codeOffset = ((ControlTransfer)byteCode).getCodeOffset();
            Assert.assertFalse((codeOffset == -1 ? 1 : 0) != 0);
            int blockId = startCodeOffsets.indexOf(codeOffset);
            ((ControlTransfer)byteCode).setCodeOffset(blockId);
        }
        int blockIdCnt = 0;
        if (startCodeOffsets.size() == 1) {
            return Lists.newArrayList((Object[])new BasicBlock[]{new BasicBlock(blockIdCnt, expressionCode.getByteCodes())});
        }
        ArrayList basicBlocks = Lists.newArrayList();
        int startCodeOffsetOfNextBlock = (Integer)startCodeOffsets.get(blockIdCnt + 1);
        int i2 = 0;
        while (i2 < expressionCode.getByteCodes().size()) {
            ArrayList byteCodesOfCurrentBlock = Lists.newArrayList();
            while (i2 < startCodeOffsetOfNextBlock) {
                byteCodesOfCurrentBlock.add(expressionCode.getByteCodes().get(i2));
                ++i2;
            }
            basicBlocks.add(new BasicBlock(blockIdCnt, byteCodesOfCurrentBlock));
            if (++blockIdCnt + 1 < startCodeOffsets.size()) {
                startCodeOffsetOfNextBlock = (Integer)startCodeOffsets.get(blockIdCnt + 1);
                continue;
            }
            startCodeOffsetOfNextBlock = expressionCode.getByteCodes().size();
        }
        return basicBlocks;
    }

    private void constantOptimization(BasicBlock basicBlock) {
        int size = basicBlock.getByteCodes().size();
        LinkedList<Object> optimizedByteCodes = new LinkedList<Object>();
        int i = 0;
        while (i < size) {
            ByteCode byteCode = (ByteCode)basicBlock.getByteCodes().get(i);
            if (!this.isConstantByteCode(byteCode)) {
                optimizedByteCodes.add(byteCode);
                ++i;
                continue;
            }
            LinkedList constantByteCodes = Lists.newLinkedList();
            while (i < size && this.isConstantByteCode(byteCode = (ByteCode)basicBlock.getByteCodes().get(i))) {
                constantByteCodes.add(byteCode);
                ++i;
            }
            LinkedList stack = Lists.newLinkedList();
            ListIterator<_nconst> iterator = constantByteCodes.listIterator(constantByteCodes.size());
            while (iterator.hasPrevious()) {
                ByteCode constantByteCode = (ByteCode)iterator.previous();
                Pair peek = (Pair)stack.peek();
                if (constantByteCode instanceof Const) {
                    Const resultConstByteCode;
                    boolean hasEnoughOperators;
                    if (peek == null) {
                        Pair pair = new Pair(null, (Object)Lists.newLinkedList());
                        ((LinkedList)pair.getSecond()).addFirst((Const)constantByteCode);
                        stack.push(pair);
                        continue;
                    }
                    Compute computeByteCode = (Compute)peek.getFirst();
                    LinkedList constByteCodes = (LinkedList)peek.getSecond();
                    constByteCodes.addFirst((Const)constantByteCode);
                    if (computeByteCode == null) {
                        hasEnoughOperators = false;
                    } else {
                        int stackOperandNum = computeByteCode.getStackOperandNum();
                        Assert.assertFalse((constByteCodes.size() > stackOperandNum ? 1 : 0) != 0);
                        boolean bl = hasEnoughOperators = constByteCodes.size() == stackOperandNum;
                    }
                    if (!hasEnoughOperators) continue;
                    LinkedList byteCodesToBeCalculated = Lists.newLinkedList();
                    byteCodesToBeCalculated.addAll(constByteCodes);
                    byteCodesToBeCalculated.add(computeByteCode);
                    stack.pop();
                    Object result = new ExpressionCode(byteCodesToBeCalculated).execute();
                    if (result == null) {
                        resultConstByteCode = new _nconst();
                    } else if (result instanceof Boolean) {
                        resultConstByteCode = new _bconst((Boolean)result);
                    } else if (result instanceof ComparableValue) {
                        resultConstByteCode = new _cconst(((ComparableValue)((Object)result)).getValue());
                    } else if (result instanceof Long) {
                        resultConstByteCode = new _lconst((Long)result);
                    } else if (result instanceof Double) {
                        resultConstByteCode = new _dconst((Double)result);
                    } else if (result instanceof String) {
                        resultConstByteCode = new _sconst((String)result);
                    } else {
                        throw new ExpressionException("unexpected constantExpressionResult='" + result.getClass().getName() + "'");
                    }
                    iterator.add((_nconst)resultConstByteCode);
                    continue;
                }
                if (constantByteCode instanceof Compute) {
                    stack.push(new Pair((Object)((Compute)constantByteCode), (Object)Lists.newLinkedList()));
                    continue;
                }
                throw new ExpressionException("unexpected constantByteCode='" + (constantByteCode == null ? null : constantByteCode.getClass().getName()) + "'");
            }
            while (!stack.isEmpty()) {
                Pair pair = (Pair)stack.pop();
                optimizedByteCodes.addAll((Collection)pair.getSecond());
                if (pair.getFirst() == null) continue;
                optimizedByteCodes.add(pair.getFirst());
            }
        }
        basicBlock.setByteCodes(optimizedByteCodes);
    }

    private boolean isConstantByteCode(ByteCode byteCode) {
        return byteCode instanceof Compute || byteCode instanceof Const;
    }

    private List<ByteCode> joinBasicBlocksToByteCodes(List<BasicBlock> basicBlocks) {
        ArrayList joinedByteCode = Lists.newArrayList();
        int codeOffset = 0;
        HashMap offsetMap = Maps.newHashMap();
        for (BasicBlock basicBlock : basicBlocks) {
            offsetMap.put(basicBlock.getId(), codeOffset);
            codeOffset += basicBlock.getByteCodes().size();
            joinedByteCode.addAll(basicBlock.getByteCodes());
        }
        for (ByteCode byteCode : joinedByteCode) {
            if (!(byteCode instanceof ControlTransfer)) continue;
            int blockId = ((ControlTransfer)byteCode).getCodeOffset();
            Assert.assertTrue((boolean)offsetMap.containsKey(blockId));
            ((ControlTransfer)byteCode).setCodeOffset((Integer)offsetMap.get(blockId));
        }
        return joinedByteCode;
    }

    private static final class BasicBlock {
        private final int id;
        private List<ByteCode> byteCodes;

        private BasicBlock(int id, List<ByteCode> byteCodes) {
            this.id = id;
            this.byteCodes = byteCodes;
        }

        private int getId() {
            return this.id;
        }

        private List<ByteCode> getByteCodes() {
            return this.byteCodes;
        }

        private void setByteCodes(List<ByteCode> byteCodes) {
            this.byteCodes = byteCodes;
        }
    }
}

