/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.compile.optimize.impl;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.expression.engine.compile.optimize.Optimizer;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf.ConditionalControlTransfer;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf.ControlTransfer;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._goto;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifeq;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifge;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifgt;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifle;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._iflt;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifne;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._bconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._cconst;
import com.github.liuyehcf.framework.expression.engine.core.model.ComparableValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ControlTransferOptimizer
implements Optimizer {
    @Override
    public void optimize(ExpressionCode expressionCode) {
        List<ByteCode> byteCodes = expressionCode.getByteCodes();
        boolean canBreak = false;
        while (!canBreak) {
            int originSize = byteCodes.size();
            this.removeConstantControlTransferCode(byteCodes);
            this.simplifyControlTransferCode(byteCodes);
            this.removeRedundantControlTransferCode(byteCodes);
            this.removeSinglePathGotoControlTransferCode(byteCodes);
            this.removeNullByteCode(byteCodes);
            Assert.assertFalse((byteCodes.size() > originSize ? 1 : 0) != 0);
            canBreak = byteCodes.size() == originSize;
        }
    }

    private void removeConstantControlTransferCode(List<ByteCode> byteCodes) {
        boolean canBreak = false;
        while (!canBreak) {
            canBreak = true;
            HashSet toCodeOffset = Sets.newHashSet();
            for (ByteCode byteCode : byteCodes) {
                if (!(byteCode instanceof ControlTransfer)) continue;
                toCodeOffset.add(((ControlTransfer)byteCode).getCodeOffset());
            }
            for (int offset = 1; offset < byteCodes.size(); ++offset) {
                ByteCode preByteCode = byteCodes.get(offset - 1);
                ByteCode byteCode = byteCodes.get(offset);
                if (toCodeOffset.contains(offset - 1) || toCodeOffset.contains(offset) || !(preByteCode instanceof _bconst) && !(preByteCode instanceof _cconst)) continue;
                ComparableValue comparableValue = preByteCode instanceof _bconst ? ((_bconst)preByteCode).getComparableValue() : ((_cconst)preByteCode).getComparableValue();
                if (byteCode instanceof _ifeq) {
                    if (comparableValue.getValue() == 0) {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, new _goto(((_ifeq)byteCode).getCodeOffset()));
                    } else {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, null);
                    }
                    canBreak = false;
                    continue;
                }
                if (byteCode instanceof _ifge) {
                    if (comparableValue.getValue() >= 0) {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, new _goto(((_ifge)byteCode).getCodeOffset()));
                    } else {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, null);
                    }
                    canBreak = false;
                    continue;
                }
                if (byteCode instanceof _ifgt) {
                    if (comparableValue.getValue() > 0) {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, new _goto(((_ifgt)byteCode).getCodeOffset()));
                    } else {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, null);
                    }
                    canBreak = false;
                    continue;
                }
                if (byteCode instanceof _ifle) {
                    if (comparableValue.getValue() <= 0) {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, new _goto(((_ifle)byteCode).getCodeOffset()));
                    } else {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, null);
                    }
                    canBreak = false;
                    continue;
                }
                if (byteCode instanceof _iflt) {
                    if (comparableValue.getValue() < 0) {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, new _goto(((_iflt)byteCode).getCodeOffset()));
                    } else {
                        byteCodes.set(offset - 1, null);
                        byteCodes.set(offset, null);
                    }
                    canBreak = false;
                    continue;
                }
                if (!(byteCode instanceof _ifne)) continue;
                if (comparableValue.getValue() != 0) {
                    byteCodes.set(offset - 1, null);
                    byteCodes.set(offset, new _goto(((_ifne)byteCode).getCodeOffset()));
                } else {
                    byteCodes.set(offset - 1, null);
                    byteCodes.set(offset, null);
                }
                canBreak = false;
            }
        }
    }

    private void simplifyControlTransferCode(List<ByteCode> byteCodes) {
        for (ByteCode byteCode : byteCodes) {
            if (!(byteCode instanceof ControlTransfer)) continue;
            ControlTransfer controlTransferCode = (ControlTransfer)byteCode;
            int codeOffset = controlTransferCode.getCodeOffset();
            codeOffset = this.getFinalCodeOffset(byteCodes, codeOffset);
            controlTransferCode.setCodeOffset(codeOffset);
        }
    }

    private void removeRedundantControlTransferCode(List<ByteCode> byteCodes) {
        HashSet<Integer> visitedCodes = new HashSet<Integer>();
        this.visitCode(0, visitedCodes, byteCodes);
        ArrayList<Integer> unvisitedCodeOffsets = new ArrayList<Integer>();
        for (int offset = 0; offset < byteCodes.size(); ++offset) {
            unvisitedCodeOffsets.add(offset);
        }
        unvisitedCodeOffsets.removeAll(visitedCodes);
        Collections.sort(unvisitedCodeOffsets);
        Iterator iterator = unvisitedCodeOffsets.iterator();
        while (iterator.hasNext()) {
            int unvisitedCodeOffset = (Integer)iterator.next();
            byteCodes.set(unvisitedCodeOffset, null);
        }
    }

    private void removeSinglePathGotoControlTransferCode(List<ByteCode> byteCodes) {
        for (int offset = 0; offset < byteCodes.size(); ++offset) {
            ByteCode byteCode = byteCodes.get(offset);
            if (byteCode instanceof _goto) {
                int toOffset = ((_goto)byteCode).getCodeOffset();
                for (int i = offset + 1; i < toOffset; ++i) {
                    Assert.assertNull((Object)byteCodes.get(i));
                }
                if (toOffset <= offset) continue;
                byteCodes.set(offset, null);
                continue;
            }
            if (!(byteCode instanceof ConditionalControlTransfer)) continue;
            return;
        }
    }

    private void removeNullByteCode(List<ByteCode> byteCodes) {
        for (ByteCode byteCode : byteCodes) {
            if (!(byteCode instanceof ControlTransfer)) continue;
            int codeOffset = ((ControlTransfer)byteCode).getCodeOffset();
            Assert.assertNotNull((Object)byteCodes.get(codeOffset));
        }
        HashMap controlTransferToCodeOffsetMap = Maps.newHashMap();
        for (ByteCode byteCode : byteCodes) {
            if (!(byteCode instanceof ControlTransfer)) continue;
            controlTransferToCodeOffsetMap.put((ControlTransfer)byteCode, ((ControlTransfer)byteCode).getCodeOffset());
        }
        ArrayList arrayList = Lists.newArrayList(byteCodes);
        byteCodes.clear();
        for (int offset = 0; offset < arrayList.size(); ++offset) {
            ByteCode byteCode = (ByteCode)arrayList.get(offset);
            if (byteCode == null) {
                for (Map.Entry entry : controlTransferToCodeOffsetMap.entrySet()) {
                    ControlTransfer controlTransfer = (ControlTransfer)entry.getKey();
                    int toOffset = (Integer)entry.getValue();
                    if (toOffset <= offset) continue;
                    controlTransfer.setCodeOffset(controlTransfer.getCodeOffset() - 1);
                }
                continue;
            }
            byteCodes.add(byteCode);
        }
    }

    private int getFinalCodeOffset(List<ByteCode> byteCodes, int codeOffset) {
        ByteCode byteCode;
        int finalCodeOffset = codeOffset;
        HashSet<ByteCode> visitedCodes = new HashSet<ByteCode>();
        while ((byteCode = byteCodes.get(finalCodeOffset)) instanceof _goto) {
            if (!visitedCodes.add(byteCode)) {
                return finalCodeOffset;
            }
            finalCodeOffset = ((ControlTransfer)byteCode).getCodeOffset();
        }
        return finalCodeOffset;
    }

    private void visitCode(int codeOffset, Set<Integer> visitedCodes, List<ByteCode> byteCodes) {
        if (codeOffset >= byteCodes.size() || visitedCodes.contains(codeOffset)) {
            return;
        }
        visitedCodes.add(codeOffset);
        ByteCode byteCode = byteCodes.get(codeOffset);
        if (byteCode instanceof ControlTransfer) {
            this.visitCode(((ControlTransfer)byteCode).getCodeOffset(), visitedCodes, byteCodes);
            if (byteCode instanceof ConditionalControlTransfer) {
                this.visitCode(codeOffset + 1, visitedCodes, byteCodes);
            }
        } else {
            this.visitCode(codeOffset + 1, visitedCodes, byteCodes);
        }
    }
}

