/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.common.tools.collection.EnvBuilder;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionVirtualMachine;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressionCode {
    private final Set<String> propertyNames = Sets.newLinkedHashSet();
    private List<ByteCode> byteCodes;

    public ExpressionCode() {
        this.byteCodes = Lists.newArrayList();
    }

    public ExpressionCode(List<ByteCode> byteCodes) {
        Assert.assertNotNull(byteCodes);
        this.byteCodes = byteCodes;
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public List<ByteCode> getByteCodes() {
        return this.byteCodes;
    }

    public void setByteCodes(List<ByteCode> byteCodes) {
        this.byteCodes = byteCodes;
    }

    public void addByteCode(ByteCode byteCode) {
        this.byteCodes.add(byteCode);
    }

    public void addPropertyName(String propertyName) {
        this.propertyNames.add(propertyName);
    }

    public <T> T exec(Object ... properties) {
        Iterator<String> iterator = this.propertyNames.iterator();
        EnvBuilder envBuilder = EnvBuilder.builder();
        int i = 0;
        while (i < properties.length && iterator.hasNext()) {
            String key = iterator.next();
            Object value = properties[i++];
            envBuilder.put(key, value);
        }
        return this.execute(envBuilder.build());
    }

    public <T> T execute() {
        return this.execute(null);
    }

    public <T> T execute(Map<String, Object> env) {
        return ExpressionVirtualMachine.execute(this, env).getValue();
    }

    public String toReadableString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.byteCodes.size(); ++i) {
            sb.append(String.format("\t%-4d%-3s%s\n", i, ":", this.byteCodes.get(i)));
        }
        return sb.toString();
    }
}

