/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.bytecode;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._goto;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifeq;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifge;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifgt;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifle;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._iflt;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cf._ifne;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._add;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._and;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._cmp;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._div;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._mul;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._neg;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._or;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._rem;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._shl;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._shr;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._sub;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._ushr;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._xor;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ir._invokestatic;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ir._return;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.oc._newarray;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._aaload;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._bconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._cconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._dconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._lconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._nconst;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._pload;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.sl._sconst;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;

public class ByteCodeUtils {
    private static final Map<Integer, Class<? extends ByteCode>> operatorCodePool = Maps.newHashMap();
    private static final String FILED_NAME_OPERATOR_CODE = "OPERATOR_CODE";
    private static final String FILED_NAME_OPERATOR_CLASSES = "OPERATOR_CLASSES";

    public static int getOperatorCode(Class<? extends ByteCode> clazz) {
        return (Integer)ByteCodeUtils.getStaticField(clazz, FILED_NAME_OPERATOR_CODE);
    }

    public static Class<?>[] getOperatorClasses(Class<? extends ByteCode> clazz) {
        return (Class[])ByteCodeUtils.getStaticField(clazz, FILED_NAME_OPERATOR_CLASSES);
    }

    private static Object getStaticField(Class<? extends ByteCode> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExpressionException(e);
        }
    }

    private static void register(Class<? extends ByteCode> clazz) {
        int operatorCode = ByteCodeUtils.getOperatorCode(clazz);
        Assert.assertFalse((boolean)operatorCodePool.containsKey(operatorCode), (String)("[SYSTEM_ERROR] - ByteCode OperatorCode repeated: " + Integer.toHexString(operatorCode)));
        operatorCodePool.put(operatorCode, clazz);
    }

    public static Class<? extends ByteCode> getByteCodeByOperatorCode(int operatorCode) {
        return operatorCodePool.get(operatorCode);
    }

    static {
        ByteCodeUtils.register(_goto.class);
        ByteCodeUtils.register(_ifeq.class);
        ByteCodeUtils.register(_ifge.class);
        ByteCodeUtils.register(_ifgt.class);
        ByteCodeUtils.register(_ifle.class);
        ByteCodeUtils.register(_iflt.class);
        ByteCodeUtils.register(_ifne.class);
        ByteCodeUtils.register(_add.class);
        ByteCodeUtils.register(_and.class);
        ByteCodeUtils.register(_cmp.class);
        ByteCodeUtils.register(_div.class);
        ByteCodeUtils.register(_mul.class);
        ByteCodeUtils.register(_neg.class);
        ByteCodeUtils.register(_or.class);
        ByteCodeUtils.register(_rem.class);
        ByteCodeUtils.register(_shl.class);
        ByteCodeUtils.register(_shr.class);
        ByteCodeUtils.register(_sub.class);
        ByteCodeUtils.register(_ushr.class);
        ByteCodeUtils.register(_xor.class);
        ByteCodeUtils.register(_invokestatic.class);
        ByteCodeUtils.register(_return.class);
        ByteCodeUtils.register(_newarray.class);
        ByteCodeUtils.register(_aaload.class);
        ByteCodeUtils.register(_bconst.class);
        ByteCodeUtils.register(_cconst.class);
        ByteCodeUtils.register(_dconst.class);
        ByteCodeUtils.register(_lconst.class);
        ByteCodeUtils.register(_nconst.class);
        ByteCodeUtils.register(_pload.class);
        ByteCodeUtils.register(_sconst.class);
    }
}

