/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.bytecode.cp;

import com.alibaba.fastjson.annotation.JSONField;
import com.github.liuyehcf.framework.expression.engine.ExpressionEngine;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.cp._cmp;
import com.github.liuyehcf.framework.expression.engine.core.function.OperatorFunction;
import com.github.liuyehcf.framework.expression.engine.core.model.ComparableValue;
import com.github.liuyehcf.framework.expression.engine.core.model.OperatorType;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionValue;
import com.github.liuyehcf.framework.expression.engine.runtime.RuntimeContext;
import java.util.List;

public abstract class Compute
extends ByteCode {
    private static final Object[] OPERATORS = new Object[0];

    @Override
    @JSONField(serialize=false)
    public final Object[] getOperators() {
        return OPERATORS;
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName();
    }

    public abstract int getStackOperandNum();

    final void operateForTwoOperand(RuntimeContext context, OperatorType type) {
        List<OperatorFunction> operatorFunctions = ExpressionEngine.getOperatorFunctions(type);
        ExpressionValue value2 = context.pop();
        ExpressionValue value1 = context.pop();
        for (OperatorFunction operatorFunction : operatorFunctions) {
            if (!operatorFunction.accept(value1, value2)) continue;
            ExpressionValue result = operatorFunction.call(value1, value2);
            if (this instanceof _cmp) {
                Object resultValue = result.getValue();
                if (!(resultValue instanceof Long)) {
                    throw new ExpressionException("CmpOperatorFunction's return type must be 'java.lang.Long' (or compatible type 'java.lang.Byte', 'java.lang.Short', 'java.lang.Integer')");
                }
                context.push(ExpressionValue.valueOf((Object)ComparableValue.valueOf((Long)resultValue)));
            } else {
                context.push(result);
            }
            context.increaseCodeOffset();
            return;
        }
        throw this.createExpressionException(type, value1, value2);
    }

    final void operateForOneOperand(RuntimeContext context, OperatorType type) {
        List<OperatorFunction> operatorFunctions = ExpressionEngine.getOperatorFunctions(type);
        ExpressionValue value = context.pop();
        for (OperatorFunction operatorFunction : operatorFunctions) {
            if (!operatorFunction.accept(value)) continue;
            ExpressionValue result = operatorFunction.call(value);
            context.push(result);
            context.increaseCodeOffset();
            return;
        }
        throw this.createExpressionException(type, value);
    }

    private ExpressionException createExpressionException(OperatorType type, ExpressionValue ... values) {
        if (values.length == 1) {
            return new ExpressionException("could not find compatible operator(" + type.getSymbol() + ") function. type='" + (values[0].getValue() == null ? null : values[0].getValue().getClass().getName()) + "'");
        }
        return new ExpressionException("could not find compatible operator(" + type.getSymbol() + ") function. type1='" + (values[0].getValue() == null ? null : values[0].getValue().getClass().getName()) + "', type2='" + (values[1].getValue() == null ? null : values[1].getValue().getClass().getName()) + "'");
    }
}

