/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.bytecode.ir;

import com.alibaba.fastjson.annotation.JSONField;
import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ir.Invoke;
import com.github.liuyehcf.framework.expression.engine.core.function.Function;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionValue;
import com.github.liuyehcf.framework.expression.engine.runtime.RuntimeContext;
import com.github.liuyehcf.framework.expression.engine.utils.FunctionUtils;
import java.util.LinkedList;

public class _invokestatic
extends Invoke {
    public static final int OPERATOR_CODE = 184;
    public static final Class<?>[] OPERATOR_CLASSES = new Class[]{String.class, Integer.TYPE};
    private final String functionName;
    private final int argSize;

    public _invokestatic(String functionName, int argSize) {
        this.functionName = functionName;
        this.argSize = argSize;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getArgSize() {
        return this.argSize;
    }

    @Override
    @JSONField(serialize=false)
    public Object[] getOperators() {
        return new Object[]{this.functionName, this.argSize};
    }

    @Override
    public void operate(RuntimeContext context) {
        Function function = FunctionUtils.getFunctionByName(this.functionName);
        LinkedList<ExpressionValue> args = new LinkedList<ExpressionValue>();
        for (int size = this.argSize; size > 0; --size) {
            args.addFirst(context.pop());
        }
        ExpressionValue result = FunctionUtils.invoke(function, args.toArray(new ExpressionValue[0]));
        Assert.assertNotNull((Object)result, (String)"function's result cannot be null");
        context.push(result);
        context.increaseCodeOffset();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getFunctionName() + ":" + this.getArgSize();
    }
}

