/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.function.collection;

import com.github.liuyehcf.framework.expression.engine.core.function.Function;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionValue;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Objects;

public class CollectionIncludeFunction
extends Function {
    @Override
    public String getName() {
        return "collection.include";
    }

    @Override
    public ExpressionValue call(ExpressionValue arg1, ExpressionValue arg2) {
        Object array = arg1.getValue();
        Object value = arg2.getValue();
        if (array == null) {
            return ExpressionValue.valueOf(false);
        }
        if (array.getClass().isArray()) {
            int size = Array.getLength(array);
            for (int i = 0; i < size; ++i) {
                Object item = Array.get(array, i);
                if (!Objects.equals(item, value)) continue;
                return ExpressionValue.valueOf(true);
            }
            return ExpressionValue.valueOf(false);
        }
        if (array instanceof Collection) {
            return ExpressionValue.valueOf(((Collection)array).contains(value));
        }
        throw this.createTypeIllegalException(1, array);
    }
}

