/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.function.string;

import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.function.Function;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionValue;

public class StringSplitFunction
extends Function {
    @Override
    public String getName() {
        return "string.split";
    }

    @Override
    public ExpressionValue call(ExpressionValue arg1, ExpressionValue arg2) {
        Object sequence = arg1.getValue();
        Object regex = arg2.getValue();
        if (sequence == null || regex == null) {
            return ExpressionValue.valueOf(new String[0]);
        }
        if (!(sequence instanceof String)) {
            throw this.createTypeIllegalException(1, sequence);
        }
        if (!(regex instanceof String)) {
            throw this.createTypeIllegalException(2, regex);
        }
        String[] segments = ((String)sequence).split((String)regex);
        return ExpressionValue.valueOf(segments);
    }

    @Override
    public ExpressionValue call(ExpressionValue arg1, ExpressionValue arg2, ExpressionValue arg3) {
        String sequence = (String)arg1.getValue();
        String regex = (String)arg2.getValue();
        Long limit = (Long)arg3.getValue();
        if (sequence == null) {
            throw new ExpressionException(this.getName() + "'s first arg is null");
        }
        if (regex == null) {
            throw new ExpressionException(this.getName() + "'s second arg is null");
        }
        if (limit == null) {
            throw new ExpressionException(this.getName() + "'s third arg is null");
        }
        String[] segments = sequence.split(regex, limit.intValue());
        return ExpressionValue.valueOf(segments);
    }
}

