/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.function.string;

import com.github.liuyehcf.framework.expression.engine.core.function.Function;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionValue;

public class StringSubStringFunction
extends Function {
    @Override
    public String getName() {
        return "string.substring";
    }

    @Override
    public ExpressionValue call(ExpressionValue arg1, ExpressionValue arg2) {
        Object sequence = arg1.getValue();
        Object beginIndex = arg2.getValue();
        if (sequence == null) {
            return ExpressionValue.valueOf(null);
        }
        if (!(sequence instanceof String)) {
            throw this.createTypeIllegalException(1, sequence);
        }
        if (beginIndex == null) {
            return ExpressionValue.valueOf(sequence);
        }
        if (!(beginIndex instanceof Long)) {
            throw this.createTypeIllegalException(2, beginIndex);
        }
        return ExpressionValue.valueOf(((String)sequence).substring(((Long)beginIndex).intValue()));
    }

    @Override
    public ExpressionValue call(ExpressionValue arg1, ExpressionValue arg2, ExpressionValue arg3) {
        Object sequence = arg1.getValue();
        Object beginIndex = arg2.getValue();
        Object endIndex = arg3.getValue();
        if (sequence == null) {
            return ExpressionValue.valueOf(null);
        }
        if (!(sequence instanceof String)) {
            throw this.createTypeIllegalException(1, sequence);
        }
        if (beginIndex == null) {
            return ExpressionValue.valueOf(sequence);
        }
        if (!(beginIndex instanceof Long)) {
            throw this.createTypeIllegalException(2, beginIndex);
        }
        if (endIndex == null) {
            return ExpressionValue.valueOf(((String)sequence).substring(((Long)beginIndex).intValue()));
        }
        if (!(endIndex instanceof Long)) {
            throw this.createTypeIllegalException(3, endIndex);
        }
        return ExpressionValue.valueOf(((String)sequence).substring(((Long)beginIndex).intValue(), ((Long)endIndex).intValue()));
    }
}

