/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.io;

import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCodeUtils;
import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class ExpressionInputStream
extends DataInputStream {
    public ExpressionInputStream(InputStream in) {
        super(in);
    }

    public ExpressionCode readExpressionCode() throws IOException {
        int byteCodeNum = this.readInt();
        ArrayList byteCodes = Lists.newArrayList();
        for (int i = 0; i < byteCodeNum; ++i) {
            byteCodes.add(this.readByteCode());
        }
        return new ExpressionCode(byteCodes);
    }

    private String readString() throws IOException {
        int len = this.readInt();
        byte[] bytes = new byte[len];
        int cnt = this.read(bytes);
        if (cnt != len) {
            throw new IOException();
        }
        return new String(bytes);
    }

    private ByteCode readByteCode() throws IOException {
        int operatorCode = this.readInt();
        Class<? extends ByteCode> byteCodeClass = ByteCodeUtils.getByteCodeByOperatorCode(operatorCode);
        Class<?>[] operatorClasses = ByteCodeUtils.getOperatorClasses(byteCodeClass);
        Object[] operators = new Object[operatorClasses.length];
        for (int i = 0; i < operatorClasses.length; ++i) {
            Class<?> clazz = operatorClasses[i];
            if (String.class.equals(clazz)) {
                operators[i] = this.readString();
                continue;
            }
            if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
                operators[i] = this.readBoolean();
                continue;
            }
            if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
                operators[i] = this.readInt();
                continue;
            }
            if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
                operators[i] = this.readLong();
                continue;
            }
            if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
                operators[i] = this.readDouble();
                continue;
            }
            throw new IOException("unexpected operatorType='" + (clazz == null ? null : clazz.getName()) + "'");
        }
        try {
            Constructor<? extends ByteCode> constructor = byteCodeClass.getConstructor(operatorClasses);
            return constructor.newInstance(operators);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }
}

