/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.core.io;

import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCodeUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ExpressionOutputStream
extends DataOutputStream {
    public ExpressionOutputStream(OutputStream out) {
        super(out);
    }

    public void writeExpressionCode(ExpressionCode expressionCode) throws IOException {
        this.writeInt(expressionCode.getByteCodes().size());
        for (int i = 0; i < expressionCode.getByteCodes().size(); ++i) {
            this.writeByteCode(expressionCode.getByteCodes().get(i));
        }
    }

    private void writeString(String s) throws IOException {
        byte[] bytes = s.getBytes();
        this.writeInt(bytes.length);
        this.write(bytes);
    }

    private void writeByteCode(ByteCode byteCode) throws IOException {
        int operatorCode = ByteCodeUtils.getOperatorCode(byteCode.getClass());
        Class<?>[] operatorClasses = ByteCodeUtils.getOperatorClasses(byteCode.getClass());
        int operatorNum = operatorClasses.length;
        Object[] operators = byteCode.getOperators();
        this.writeInt(operatorCode);
        for (int i = 0; i < operatorNum; ++i) {
            Class<?> clazz = operatorClasses[i];
            if (String.class.equals(clazz)) {
                this.writeString((String)operators[i]);
                continue;
            }
            if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
                this.writeBoolean((Boolean)operators[i]);
                continue;
            }
            if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
                this.writeInt((Integer)operators[i]);
                continue;
            }
            if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
                this.writeLong((Long)operators[i]);
                continue;
            }
            if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
                this.writeDouble((Double)operators[i]);
                continue;
            }
            throw new IOException("unexpected operatorType='" + (clazz == null ? null : clazz.getName()) + "'");
        }
    }
}

