/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.runtime;

import com.github.liuyehcf.framework.expression.engine.core.ExpressionException;
import com.github.liuyehcf.framework.expression.engine.core.model.ComparableValue;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionType;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionValue;
import java.util.List;

public final class ExpressionValueImpl
implements ExpressionValue {
    private static final ExpressionValueImpl NULL = new ExpressionValueImpl();
    private final ExpressionType type;
    private final Object value;

    private ExpressionValueImpl() {
        this.type = ExpressionType.NULL;
        this.value = null;
    }

    private ExpressionValueImpl(Object originValue) {
        Object actualValue;
        ExpressionType actualType;
        if (originValue instanceof Boolean) {
            actualType = ExpressionType.BOOLEAN;
            actualValue = (Boolean)originValue != false ? 1L : 0L;
        } else if (originValue instanceof Byte) {
            actualType = ExpressionType.LONG;
            actualValue = (long)((Byte)originValue).byteValue();
        } else if (originValue instanceof Character) {
            actualType = ExpressionType.STRING;
            actualValue = "" + ((Character)originValue).charValue();
        } else if (originValue instanceof Short) {
            actualType = ExpressionType.LONG;
            actualValue = (long)((Short)originValue).shortValue();
        } else if (originValue instanceof Integer) {
            actualType = ExpressionType.LONG;
            actualValue = (long)((Integer)originValue).intValue();
        } else if (originValue instanceof Long) {
            actualType = ExpressionType.LONG;
            actualValue = originValue;
        } else if (originValue instanceof Float) {
            actualType = ExpressionType.DOUBLE;
            actualValue = (double)((Float)originValue).floatValue();
        } else if (originValue instanceof Double) {
            actualType = ExpressionType.DOUBLE;
            actualValue = originValue;
        } else if (originValue instanceof ComparableValue) {
            actualType = ExpressionType.COMPARABLE_VALUE;
            actualValue = originValue;
        } else {
            actualType = originValue instanceof String ? ExpressionType.STRING : (originValue.getClass().isArray() ? ExpressionType.ARRAY : (originValue instanceof List ? ExpressionType.LIST : ExpressionType.OBJECT));
            actualValue = originValue;
        }
        this.value = actualValue;
        this.type = actualType;
    }

    public static ExpressionValueImpl valueOf(Object object) {
        if (object == null) {
            return NULL;
        }
        return new ExpressionValueImpl(object);
    }

    @Override
    public <T> T getValue() {
        return (T)this.getValue0();
    }

    private Object getValue0() {
        switch (this.type) {
            case BOOLEAN: {
                return (Long)this.value == 1L;
            }
            case NULL: 
            case COMPARABLE_VALUE: 
            case LONG: 
            case DOUBLE: 
            case STRING: 
            case ARRAY: 
            case LIST: 
            case OBJECT: {
                return this.value;
            }
        }
        throw new ExpressionException("unexpected expressionType='" + (Object)((Object)this.type) + "'");
    }

    public String toString() {
        return "ExpressionValueImpl{type=" + (Object)((Object)this.type) + ", value=" + this.value + '}';
    }
}

