/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.expression.engine.runtime;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.expression.engine.core.ExpressionCode;
import com.github.liuyehcf.framework.expression.engine.core.bytecode.ByteCode;
import com.github.liuyehcf.framework.expression.engine.runtime.ExpressionValue;
import com.github.liuyehcf.framework.expression.engine.runtime.RuntimeContext;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class ExpressionVirtualMachine
implements RuntimeContext {
    private final LinkedList<ExpressionValue> operatorStack = new LinkedList();
    private final ExpressionCode expressionCode;
    private final Map<String, Object> env;
    private int codeOffset = 0;

    private ExpressionVirtualMachine(ExpressionCode expressionCode, Map<String, Object> env) {
        Assert.assertNotNull((Object)expressionCode);
        this.expressionCode = expressionCode;
        this.env = env == null ? Maps.newHashMap() : env;
    }

    public static ExpressionValue execute(ExpressionCode expressionCode, Map<String, Object> env) {
        return new ExpressionVirtualMachine(expressionCode, env).execute();
    }

    @Override
    public void push(ExpressionValue originOperator) {
        this.operatorStack.push(originOperator);
    }

    @Override
    public ExpressionValue pop() {
        return this.operatorStack.pop();
    }

    @Override
    public void increaseCodeOffset() {
        ++this.codeOffset;
    }

    @Override
    public void setCodeOffset(int offset) {
        this.codeOffset = offset;
    }

    @Override
    public Object getProperty(String propertyName) {
        try {
            return PropertyUtils.getProperty(this.env, (String)propertyName);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private ExpressionValue execute() {
        List<ByteCode> byteCodes = this.expressionCode.getByteCodes();
        while (this.codeOffset < byteCodes.size()) {
            byteCodes.get(this.codeOffset).operate(this);
        }
        return this.operatorStack.pop();
    }
}

