/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.rpc.ares.spring;

import com.github.liuyehcf.framework.rpc.ares.ObjectToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.ObjectToStringCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.BigDecimalToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.BigIntegerToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.BooleanToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.ByteToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.BytesToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.DoubleToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.FloatToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.IntToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.LongToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.MapToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.PojoToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.ShortToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.StringToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.codes.VoidToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.spring.AresConsumerSpringPostProcessor;
import java.util.Collections;
import java.util.List;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import sun.net.ConnectionResetException;

@ConfigurationProperties(prefix="ares.http.config")
public class AresAutoConfiguration {
    private int maxTotal = 200;
    private int defaultMaxPerRoute = 200;
    private int retryTimes = 3;
    private int socketTimeout = 2000;
    private int connectTimeout = 2000;
    private int connectionRequestTimeout = 2000;

    @Bean
    @ConditionalOnMissingBean
    public HttpClient httpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(this.maxTotal);
        connectionManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((exception, executionCount, context) -> {
            if (executionCount > this.retryTimes) {
                return false;
            }
            return exception instanceof NoHttpResponseException || exception instanceof ConnectionResetException;
        }).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestConfig requestConfig() {
        return RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).build();
    }

    @Bean
    public BeanFactoryPostProcessor aresConsumerSpringPostProcessor(@Autowired List<ObjectToStringCodes<?>> stringCodes, @Autowired List<ObjectToBytesCodes<?>> byteCodes) {
        Collections.sort(stringCodes);
        Collections.sort(byteCodes);
        return new AresConsumerSpringPostProcessor(stringCodes, byteCodes);
    }

    @Bean(name={"aresBytesToBytesCodes"})
    public BytesToBytesCodes bytesToByteCodes() {
        return new BytesToBytesCodes();
    }

    @Bean(name={"aresBooleanToBytesCodes"})
    public BooleanToBytesCodes booleanToBytesCodes() {
        return new BooleanToBytesCodes();
    }

    @Bean(name={"aresByteToBytesCodes"})
    public ByteToBytesCodes byteToByteCodes() {
        return new ByteToBytesCodes();
    }

    @Bean(name={"aresShortToBytesCodes"})
    public ShortToBytesCodes shortToByteCodes() {
        return new ShortToBytesCodes();
    }

    @Bean(name={"aresIntToBytesCodes"})
    public IntToBytesCodes intToByteCodes() {
        return new IntToBytesCodes();
    }

    @Bean(name={"aresLongToBytesCodes"})
    public LongToBytesCodes longToByteCodes() {
        return new LongToBytesCodes();
    }

    @Bean(name={"aresFloatToBytesCodes"})
    public FloatToBytesCodes floatToByteCodes() {
        return new FloatToBytesCodes();
    }

    @Bean(name={"aresDoubleToBytesCodes"})
    public DoubleToBytesCodes doubleToByteCodes() {
        return new DoubleToBytesCodes();
    }

    @Bean(name={"aresVoidToBytesCodes"})
    public VoidToBytesCodes voidToBytesCodes() {
        return new VoidToBytesCodes();
    }

    @Bean(name={"aresStringToBytesCodes"})
    public StringToBytesCodes stringToBytesCodes() {
        return new StringToBytesCodes();
    }

    @Bean(name={"aresMapToBytesCodes"})
    public MapToBytesCodes mapToBytesCodes() {
        return new MapToBytesCodes();
    }

    @Bean(name={"aresPojoToBytesCodes"})
    public PojoToBytesCodes pojoToBytesCodes() {
        return new PojoToBytesCodes();
    }

    @Bean(name={"aresBigIntegerToBytesCodes"})
    public BigIntegerToBytesCodes bigIntegerToBytesCodes() {
        return new BigIntegerToBytesCodes();
    }

    @Bean(name={"aresBigDecimalToBytesCodes"})
    public BigDecimalToBytesCodes bigDecimalToBytesCodes() {
        return new BigDecimalToBytesCodes();
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AresAutoConfiguration)) {
            return false;
        }
        AresAutoConfiguration other = (AresAutoConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        if (this.getDefaultMaxPerRoute() != other.getDefaultMaxPerRoute()) {
            return false;
        }
        if (this.getRetryTimes() != other.getRetryTimes()) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        return this.getConnectionRequestTimeout() == other.getConnectionRequestTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AresAutoConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxTotal();
        result = result * 59 + this.getDefaultMaxPerRoute();
        result = result * 59 + this.getRetryTimes();
        result = result * 59 + this.getSocketTimeout();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getConnectionRequestTimeout();
        return result;
    }

    public String toString() {
        return "AresAutoConfiguration(maxTotal=" + this.getMaxTotal() + ", defaultMaxPerRoute=" + this.getDefaultMaxPerRoute() + ", retryTimes=" + this.getRetryTimes() + ", socketTimeout=" + this.getSocketTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ")";
    }
}

