/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.rpc.ares.spring;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.rpc.ares.AresException;
import com.github.liuyehcf.framework.rpc.ares.AresMethod;
import com.github.liuyehcf.framework.rpc.ares.AresPathVariable;
import com.github.liuyehcf.framework.rpc.ares.AresRequestBody;
import com.github.liuyehcf.framework.rpc.ares.AresRequestHeader;
import com.github.liuyehcf.framework.rpc.ares.AresRequestParam;
import com.github.liuyehcf.framework.rpc.ares.ObjectToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.ObjectToStringCodes;
import com.github.liuyehcf.framework.rpc.ares.constant.HttpMethod;
import com.github.liuyehcf.framework.rpc.ares.util.AresContext;
import com.github.liuyehcf.framework.rpc.ares.util.PathUtils;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.springframework.core.annotation.AnnotationUtils;

class AresConsumerInvocationHandler
implements InvocationHandler {
    private final HttpClient httpClient;
    private final RequestConfig requestConfig;
    private final List<ObjectToStringCodes<?>> stringCodes;
    private final List<ObjectToBytesCodes<?>> byteCodes;
    private final String schema;
    private final String host;
    private final int port;

    AresConsumerInvocationHandler(HttpClient httpClient, RequestConfig requestConfig, List<ObjectToStringCodes<?>> stringCodes, List<ObjectToBytesCodes<?>> byteCodes, String schema, String host, int port) {
        this.httpClient = httpClient;
        this.requestConfig = requestConfig;
        this.stringCodes = stringCodes;
        this.byteCodes = byteCodes;
        this.schema = schema;
        this.host = host;
        this.port = port;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        AresMethod aresMethodAnnotation = (AresMethod)AnnotationUtils.getAnnotation((Method)method, AresMethod.class);
        Assert.assertNotNull((Object)aresMethodAnnotation, (String)"http consumer missing AresMethod");
        String path = aresMethodAnnotation.path();
        HttpMethod httpMethod = aresMethodAnnotation.method();
        path = this.renderPath(path, method.getParameters(), args);
        HttpParams httpParams = this.parseParams(method.getParameters(), args);
        HttpRequestBase httpRequest = this.buildRequest(path, httpMethod, httpParams);
        return this.doInvoke(httpRequest, method);
    }

    private String renderPath(String path, Parameter[] parameters, Object[] args) {
        HashMap context = Maps.newHashMap();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            AresPathVariable aresPathVariable = (AresPathVariable)AnnotationUtils.getAnnotation((AnnotatedElement)parameter, AresPathVariable.class);
            if (aresPathVariable == null) continue;
            String name = aresPathVariable.name();
            context.put(name, this.stringEncode(args[i]));
        }
        return PathUtils.render(path, context);
    }

    private HttpParams parseParams(Parameter[] parameters, Object[] args) {
        HashMap queryParams = Maps.newHashMap();
        HashMap headers = Maps.newHashMap();
        boolean hasRequestBody = false;
        Object requestBody = null;
        String contentType = null;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            AresPathVariable aresPathVariable = (AresPathVariable)AnnotationUtils.getAnnotation((AnnotatedElement)parameter, AresPathVariable.class);
            AresRequestParam aresRequestParam = (AresRequestParam)AnnotationUtils.getAnnotation((AnnotatedElement)parameter, AresRequestParam.class);
            AresRequestHeader aresRequestHeader = (AresRequestHeader)AnnotationUtils.getAnnotation((AnnotatedElement)parameter, AresRequestHeader.class);
            AresRequestBody aresRequestBody = (AresRequestBody)AnnotationUtils.getAnnotation((AnnotatedElement)parameter, AresRequestBody.class);
            int annotationNum = 0;
            if (aresPathVariable != null) {
                ++annotationNum;
            }
            if (aresRequestParam != null) {
                ++annotationNum;
            }
            if (aresRequestHeader != null) {
                ++annotationNum;
            }
            if (aresRequestBody != null) {
                ++annotationNum;
            }
            if (annotationNum > 1) {
                throw new AresException("parameter contains more than one of ares annotations");
            }
            if (aresRequestParam != null) {
                if (queryParams.containsKey(aresRequestParam.name())) {
                    throw new AresException(String.format("duplicate query parameter '%s'", aresRequestParam.name()));
                }
                queryParams.put(aresRequestParam.name(), args[i]);
                continue;
            }
            if (aresRequestHeader != null) {
                if (headers.containsKey(aresRequestHeader.name())) {
                    throw new AresException(String.format("duplicate header '%s'", aresRequestHeader.name()));
                }
                headers.put(aresRequestHeader.name(), args[i]);
                continue;
            }
            if (aresRequestBody != null) {
                Assert.assertFalse((boolean)hasRequestBody, (String)"more than one '@AresRequestBody'");
                hasRequestBody = true;
                requestBody = args[i];
                contentType = aresRequestBody.contentType();
                continue;
            }
            if (aresPathVariable != null) continue;
            throw new AresException("parameter missing '@AresRequestParam' or '@AresHeader' or '@AresRequestBody'");
        }
        return new HttpParams(queryParams, headers, requestBody, contentType);
    }

    private HttpRequestBase buildRequest(String path, HttpMethod httpMethod, HttpParams httpParams) throws Exception {
        byte[] bytes;
        String content;
        RequestBuilder builder = RequestBuilder.create((String)httpMethod.name());
        AresContext.Endpoint endpoint = AresContext.getEndpoint();
        URIBuilder uriBuilder = new URIBuilder();
        if (endpoint != null && endpoint.getSchema() != null) {
            uriBuilder.setScheme(endpoint.getSchema().name());
        } else {
            uriBuilder.setScheme(this.schema);
        }
        if (endpoint != null && StringUtils.isNotBlank((CharSequence)endpoint.getHost())) {
            uriBuilder.setHost(endpoint.getHost());
        } else {
            uriBuilder.setHost(this.host);
        }
        if (endpoint != null && endpoint.getPort() != null) {
            uriBuilder.setPort(endpoint.getPort().intValue());
        } else {
            uriBuilder.setPort(this.port);
        }
        uriBuilder.setPath(path);
        if (MapUtils.isNotEmpty((Map)httpParams.requestParams)) {
            for (Map.Entry entry : httpParams.requestParams.entrySet()) {
                Object requestParam = entry.getValue();
                content = this.stringEncode(requestParam);
                if (content == null) continue;
                uriBuilder.addParameter((String)entry.getKey(), content);
            }
        }
        if (MapUtils.isNotEmpty((Map)httpParams.requestHeaders)) {
            for (Map.Entry entry : httpParams.requestHeaders.entrySet()) {
                Object requestHeader = entry.getValue();
                content = this.stringEncode(requestHeader);
                if (content == null) continue;
                builder.addHeader((String)entry.getKey(), content);
            }
        }
        if (httpParams.requestBody != null && (bytes = this.byteEncode(httpParams.requestBody)) != null) {
            ContentType contentType = StringUtils.isBlank((CharSequence)httpParams.contentType) ? null : ContentType.parse((String)httpParams.contentType);
            builder.setEntity((HttpEntity)new ByteArrayEntity(bytes, contentType));
        }
        builder.setUri(uriBuilder.build().toASCIIString());
        return (HttpRequestBase)builder.build();
    }

    private Object doInvoke(HttpRequestBase httpRequest, Method method) {
        httpRequest.setConfig(this.requestConfig);
        String url = null;
        HttpResponse response = null;
        try {
            url = httpRequest.getURI().toASCIIString();
            response = this.httpClient.execute((HttpUriRequest)httpRequest);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                throw new AresException(String.format("http request failed, url=%s; code=%d; message=%s", url, statusCode, EntityUtils.toString((HttpEntity)response.getEntity())));
            }
            Object object = this.byteDecode(EntityUtils.toByteArray((HttpEntity)response.getEntity()), method.getGenericReturnType());
            return object;
        }
        catch (AresException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AresException(String.format("http request error, url=%s; message=%s", url, e.getMessage()), e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private String stringEncode(Object obj) {
        if (obj == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(this.stringCodes)) {
            for (ObjectToStringCodes<?> codes : this.stringCodes) {
                if (codes == null || !codes.matchEncodeObject(obj)) continue;
                return codes.encode(obj);
            }
        }
        return Objects.toString(obj);
    }

    private byte[] byteEncode(Object obj) {
        String text;
        if (obj == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(this.byteCodes)) {
            for (ObjectToBytesCodes<?> codes : this.byteCodes) {
                if (codes == null || !codes.matchEncodeObject(obj)) continue;
                return codes.encode(obj);
            }
        }
        if ((text = this.stringEncode(obj)) == null) {
            return null;
        }
        return text.getBytes();
    }

    private Object byteDecode(byte[] bytes, Type targetType) {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(this.byteCodes)) {
            for (ObjectToBytesCodes<?> codes : this.byteCodes) {
                if (codes == null || !codes.matchDecodeType(targetType)) continue;
                return codes.decode(bytes, targetType);
            }
        }
        throw new AresException("cannot find ObjectToByteCodes compatible with '" + targetType.getTypeName() + "'");
    }

    private static final class HttpParams {
        private final Map<String, Object> requestParams;
        private final Map<String, Object> requestHeaders;
        private final Object requestBody;
        private final String contentType;

        private HttpParams(Map<String, Object> requestParams, Map<String, Object> requestHeaders, Object requestBody, String contentType) {
            this.requestParams = requestParams;
            this.requestHeaders = requestHeaders;
            this.requestBody = requestBody;
            this.contentType = contentType;
        }
    }
}

