/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.rpc.ares.spring;

import com.github.liuyehcf.framework.common.tools.asserts.Assert;
import com.github.liuyehcf.framework.rpc.ares.AresConsumer;
import com.github.liuyehcf.framework.rpc.ares.ObjectToBytesCodes;
import com.github.liuyehcf.framework.rpc.ares.ObjectToStringCodes;
import com.github.liuyehcf.framework.rpc.ares.spring.AresSpringConsumerBean;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AresConsumerSpringPostProcessor
implements BeanFactoryPostProcessor {
    private static final String FIELD_OBJECT_TYPE = "objectType";
    private static final String FIELD_SCHEMA = "schema";
    private static final String FIELD_HOST = "host";
    private static final String FIELD_PORT = "port";
    private static final String FIELD_STRING_CODES = "stringCodes";
    private static final String FIELD_BYTE_CODES = "byteCodes";
    private final List<ObjectToStringCodes<?>> stringCodes;
    private final List<ObjectToBytesCodes<?>> byteCodes;

    public AresConsumerSpringPostProcessor(List<ObjectToStringCodes<?>> stringCodes, List<ObjectToBytesCodes<?>> byteCodes) {
        this.stringCodes = stringCodes;
        this.byteCodes = byteCodes;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanDefinitionName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanDefinitionName);
            String beanClassName = definition.getBeanClassName();
            if (beanClassName == null) continue;
            Class beanClass = ClassUtils.resolveClassName((String)definition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
            ReflectionUtils.doWithFields((Class)beanClass, field -> this.processHttpConsumerBean(field, (DefaultListableBeanFactory)beanFactory));
        }
    }

    private void processHttpConsumerBean(Field field, DefaultListableBeanFactory beanFactory) {
        AresConsumer annotation = (AresConsumer)AnnotationUtils.getAnnotation((AnnotatedElement)field, AresConsumer.class);
        if (annotation == null) {
            return;
        }
        Class<?> fieldType = field.getType();
        Assert.assertTrue((boolean)fieldType.isInterface(), (String)"The type of the field to which '@AresConsumer' belongs must be the interface type.");
        String schema = beanFactory.resolveEmbeddedValue(annotation.schema().name());
        String domain = beanFactory.resolveEmbeddedValue(annotation.host());
        String port = beanFactory.resolveEmbeddedValue(annotation.port());
        Assert.assertNotBlank((String)schema, (String)"'@AresConsumer' missing schema");
        Assert.assertNotBlank((String)domain, (String)"'@AresConsumer' missing domain");
        Assert.assertNotNull((Object)port, (String)"'@AresConsumer' missing port");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AresSpringConsumerBean.class);
        builder.addPropertyValue(FIELD_STRING_CODES, this.stringCodes);
        builder.addPropertyValue(FIELD_BYTE_CODES, this.byteCodes);
        builder.addPropertyValue(FIELD_OBJECT_TYPE, fieldType);
        builder.addPropertyValue(FIELD_SCHEMA, (Object)schema);
        builder.addPropertyValue(FIELD_HOST, (Object)domain);
        builder.addPropertyValue(FIELD_PORT, (Object)Integer.parseInt(port));
        builder.setScope("singleton");
        beanFactory.registerBeanDefinition(field.getName(), (BeanDefinition)builder.getBeanDefinition());
    }
}

