/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyehcf.framework.rpc.ares.util;

import com.github.liuyehcf.framework.rpc.ares.constant.SchemaType;

public abstract class AresContext {
    private static final ThreadLocal<Endpoint> ENDPOINT = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invokeWithEndpoint(SchemaType schemaType, String host, Integer port, Invoker<T> invoker) {
        try {
            AresContext.setEndpoint(schemaType, host, port);
            T t = invoker.invoke();
            return t;
        }
        finally {
            AresContext.removeEndpoint();
        }
    }

    public static void setEndpoint(SchemaType schemaType, String host, Integer port) {
        ENDPOINT.set(new Endpoint(schemaType, host, port));
    }

    public static Endpoint getEndpoint() {
        return ENDPOINT.get();
    }

    public static void removeEndpoint() {
        ENDPOINT.remove();
    }

    public static final class Endpoint {
        private final SchemaType schema;
        private final String host;
        private final Integer port;

        public SchemaType getSchema() {
            return this.schema;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Endpoint)) {
                return false;
            }
            Endpoint other = (Endpoint)o;
            SchemaType this$schema = this.getSchema();
            SchemaType other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !((Object)((Object)this$schema)).equals((Object)other$schema)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            return !(this$port == null ? other$port != null : !((Object)this$port).equals(other$port));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaType $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : ((Object)((Object)$schema)).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            return result;
        }

        public String toString() {
            return "AresContext.Endpoint(schema=" + (Object)((Object)this.getSchema()) + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }

        public Endpoint(SchemaType schema, String host, Integer port) {
            this.schema = schema;
            this.host = host;
            this.port = port;
        }
    }

    public static interface Invoker<T> {
        public T invoke();
    }
}

