/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import weixin.popular.bean.pay.PayPackage;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.MapUtil;
import weixin.popular.util.SignatureUtil;

public class JsUtil {
    public static final String[] ALL_JS_API_LIST = new String[]{"onMenuShareTimeline", "onMenuShareAppMessage", "onMenuShareQQ", "onMenuShareWeibo", "startRecord", "stopRecord", "onVoiceRecordEnd", "playVoice", "pauseVoice", "stopVoice", "onVoicePlayEnd", "uploadVoice", "downloadVoice", "chooseImage", "previewImage", "uploadImage", "downloadImage", "translateVoice", "getNetworkType", "openLocation", "getLocation", "hideOptionMenu", "showOptionMenu", "hideMenuItems", "showMenuItems", "hideAllNonBaseMenuItem", "showAllNonBaseMenuItem", "closeWindow", "scanQRCode", "chooseWXPay", "openProductSpecificView", "addCard", "chooseCard", "openCard"};

    public static String generateConfigSignature(String noncestr, String jsapi_ticket, String timestamp, String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("noncestr", noncestr);
        map.put("jsapi_ticket", jsapi_ticket);
        map.put("timestamp", timestamp);
        map.put("url", url);
        return SignatureUtil.generatePaySign(map, null);
    }

    public static String generateConfigJson(String jsapi_ticket, boolean debug, String appId, String url, String ... jsApiList) {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = UUID.randomUUID().toString();
        String signature = JsUtil.generateConfigSignature(nonceStr, jsapi_ticket, String.valueOf(timestamp), url);
        return "{" + "debug:" + debug + "," + "appId:" + "'" + appId + "'" + "," + "timestamp:" + timestamp + "," + "nonceStr:" + "'" + nonceStr + "'" + "," + "signature:" + "'" + signature + "'" + "," + "jsApiList:" + JsonUtil.toJSONString(jsApiList == null ? ALL_JS_API_LIST : jsApiList) + "}";
    }

    public static String generateChooseWXPayJson(PayPackage payPackage, String appid, String paternerKey, String paySignkey) {
        Map<String, String> mapP = MapUtil.objectToMap(payPackage, new String[0]);
        String package_ = SignatureUtil.generatePackage(mapP, paternerKey);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = UUID.randomUUID().toString();
        map.put("timestamp", String.valueOf(timestamp));
        map.put("noncestr", noncestr);
        map.put("package", package_);
        map.put("appid", appid);
        String paySign = SignatureUtil.generatePaySign(map, paySignkey);
        map.put("paySign", paySign);
        map.remove("appid");
        return JsonUtil.toJSONString(map);
    }
}

