/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.poi.CategoryListResult;
import weixin.popular.bean.poi.Poi;
import weixin.popular.bean.poi.PoiListResult;
import weixin.popular.bean.poi.PoiResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;

public class PoiAPI
extends BaseAPI {
    public static BaseResult addPoi(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/poi/addpoi").addParameter("access_token", API.accessToken(accessToken)).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult addPoi(String accessToken, Poi poi) {
        return PoiAPI.addPoi(accessToken, JsonUtil.toJSONString(poi));
    }

    public static PoiResult getPoi(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/poi/getpoi").addParameter("access_token", API.accessToken(accessToken)).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, PoiResult.class);
    }

    public static PoiResult getPoiByPoiId(String accessToken, String poi_id) {
        return PoiAPI.getPoi(accessToken, String.format("{\"poi_id\": \"%s\"}", poi_id));
    }

    public static PoiListResult getPoiList(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/poi/getpoilist").addParameter("access_token", API.accessToken(accessToken)).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, PoiListResult.class);
    }

    public static PoiListResult getPoiList(String accessToken, int begin, int limit) {
        return PoiAPI.getPoiList(accessToken, String.format("{\"begin\":%d, \"limit\": %d}", begin, limit));
    }

    public static BaseResult updatePoi(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/poi/updatepoi").addParameter("access_token", API.accessToken(accessToken)).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult updatePoi(String accessToken, Poi poi) {
        return PoiAPI.updatePoi(accessToken, JsonUtil.toJSONString(poi));
    }

    public static BaseResult delPoi(String accessToken, String postJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/poi/delpoi").addParameter("access_token", API.accessToken(accessToken)).setEntity((HttpEntity)new StringEntity(postJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult delPoiByPoiId(String accessToken, String poiId) {
        return PoiAPI.delPoi(accessToken, String.format("{\"poi_id\": \"%s\"}", poiId));
    }

    public static CategoryListResult getWxCategory(String accessToken) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/cgi-bin/poi/getwxcategory").addParameter("access_token", API.accessToken(accessToken)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CategoryListResult.class);
    }
}

