/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.paymch.Authcodetoopenid;
import weixin.popular.bean.paymch.AuthcodetoopenidResult;
import weixin.popular.bean.paymch.Closeorder;
import weixin.popular.bean.paymch.DownloadbillResult;
import weixin.popular.bean.paymch.Gethbinfo;
import weixin.popular.bean.paymch.GethbinfoResult;
import weixin.popular.bean.paymch.Gettransferinfo;
import weixin.popular.bean.paymch.GettransferinfoResult;
import weixin.popular.bean.paymch.MchBaseResult;
import weixin.popular.bean.paymch.MchDownloadbill;
import weixin.popular.bean.paymch.MchOrderInfoResult;
import weixin.popular.bean.paymch.MchOrderquery;
import weixin.popular.bean.paymch.MchReverse;
import weixin.popular.bean.paymch.MchReverseResult;
import weixin.popular.bean.paymch.MchShorturl;
import weixin.popular.bean.paymch.MchShorturlResult;
import weixin.popular.bean.paymch.Micropay;
import weixin.popular.bean.paymch.MicropayResult;
import weixin.popular.bean.paymch.PapayDeletecontract;
import weixin.popular.bean.paymch.PapayDeletecontractResult;
import weixin.popular.bean.paymch.PapayEntrustweb;
import weixin.popular.bean.paymch.PapayH5entrustwebResult;
import weixin.popular.bean.paymch.PapayQuerycontract;
import weixin.popular.bean.paymch.PapayQuerycontractResult;
import weixin.popular.bean.paymch.Pappayapply;
import weixin.popular.bean.paymch.PappayapplyResult;
import weixin.popular.bean.paymch.PayContractorder;
import weixin.popular.bean.paymch.PayContractorderResult;
import weixin.popular.bean.paymch.PayDownloadfundflow;
import weixin.popular.bean.paymch.PayDownloadfundflowResult;
import weixin.popular.bean.paymch.PayProfitsharingOperation;
import weixin.popular.bean.paymch.PayProfitsharingquery;
import weixin.popular.bean.paymch.PayProfitsharingqueryResult;
import weixin.popular.bean.paymch.QueryCoupon;
import weixin.popular.bean.paymch.QueryCouponResult;
import weixin.popular.bean.paymch.QueryCouponStock;
import weixin.popular.bean.paymch.QueryCouponStockResult;
import weixin.popular.bean.paymch.Refundquery;
import weixin.popular.bean.paymch.RefundqueryResult;
import weixin.popular.bean.paymch.Report;
import weixin.popular.bean.paymch.SandboxSignkey;
import weixin.popular.bean.paymch.SecapiPayProfitsharing;
import weixin.popular.bean.paymch.SecapiPayProfitsharingResult;
import weixin.popular.bean.paymch.SecapiPayProfitsharingfinish;
import weixin.popular.bean.paymch.SecapiPayProfitsharingfinishResult;
import weixin.popular.bean.paymch.SecapiPayRefund;
import weixin.popular.bean.paymch.SecapiPayRefundResult;
import weixin.popular.bean.paymch.SendCoupon;
import weixin.popular.bean.paymch.SendCouponResult;
import weixin.popular.bean.paymch.Sendgroupredpack;
import weixin.popular.bean.paymch.Sendredpack;
import weixin.popular.bean.paymch.SendredpackResult;
import weixin.popular.bean.paymch.Transfers;
import weixin.popular.bean.paymch.TransfersResult;
import weixin.popular.bean.paymch.Unifiedorder;
import weixin.popular.bean.paymch.UnifiedorderResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.MapUtil;
import weixin.popular.util.SignatureUtil;
import weixin.popular.util.StreamUtils;
import weixin.popular.util.XMLConverUtil;

public class PayMchAPI
extends BaseAPI {
    private static ThreadLocal<Boolean> sandboxnew = new ThreadLocal();

    public static void sandboxnewStart() {
        sandboxnew.set(true);
    }

    public static void sandboxnewEnd() {
        sandboxnew.set(null);
    }

    private static String baseURI() {
        if (sandboxnew.get() == null) {
            return "https://api.mch.weixin.qq.com";
        }
        return "https://api.mch.weixin.qq.com/sandboxnew";
    }

    public static SandboxSignkey sandboxnewPayGetsignkey(String mch_id, String key) {
        MchBaseResult mchBaseResult = new MchBaseResult();
        mchBaseResult.setMch_id(mch_id);
        mchBaseResult.setNonce_str(UUID.randomUUID().toString().replace("-", ""));
        Map<String, String> map = MapUtil.objectToMap(mchBaseResult, new String[0]);
        String sign = SignatureUtil.generateSign(map, mchBaseResult.getSign_type(), key);
        mchBaseResult.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(mchBaseResult);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri("https://api.mch.weixin.qq.com/sandboxnew/pay/getsignkey").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, SandboxSignkey.class, mchBaseResult.getSign_type(), key);
    }

    public static UnifiedorderResult payUnifiedorder(Unifiedorder unifiedorder, String key) {
        Map<String, String> map = MapUtil.objectToMap(unifiedorder, "detail", "scene_info");
        if (unifiedorder.getDetail() != null) {
            map.put("detail", JsonUtil.toJSONString(unifiedorder.getDetail()));
        }
        if (unifiedorder.getScene_info() != null) {
            map.put("scene_info", JsonUtil.toJSONString(unifiedorder.getScene_info()));
        }
        if (key != null) {
            String sign = SignatureUtil.generateSign(map, unifiedorder.getSign_type(), key);
            unifiedorder.setSign(sign);
        }
        String unifiedorderXML = XMLConverUtil.convertToXML(unifiedorder);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/unifiedorder").setEntity((HttpEntity)new StringEntity(unifiedorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, UnifiedorderResult.class, unifiedorder.getSign_type(), key);
    }

    public static MicropayResult payMicropay(Micropay micropay, String key) {
        Map<String, String> map = MapUtil.objectToMap(micropay, new String[0]);
        if (micropay.getDetail() != null) {
            map.put("detail", JsonUtil.toJSONString(micropay.getDetail()));
        }
        if (micropay.getScene_info() != null) {
            map.put("scene_info", JsonUtil.toJSONString(micropay.getScene_info()));
        }
        String sign = SignatureUtil.generateSign(map, micropay.getSign_type(), key);
        micropay.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(micropay);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/micropay").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MicropayResult.class, micropay.getSign_type(), key);
    }

    public static MchOrderInfoResult payOrderquery(MchOrderquery mchOrderquery, String key) {
        Map<String, String> map = MapUtil.objectToMap(mchOrderquery, new String[0]);
        String sign = SignatureUtil.generateSign(map, mchOrderquery.getSign_type(), key);
        mchOrderquery.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(mchOrderquery);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/orderquery").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MchOrderInfoResult.class, mchOrderquery.getSign_type(), key);
    }

    public static MchBaseResult payCloseorder(Closeorder closeorder, String key) {
        Map<String, String> map = MapUtil.objectToMap(closeorder, new String[0]);
        String sign = SignatureUtil.generateSign(map, closeorder.getSign_type(), key);
        closeorder.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(closeorder);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/closeorder").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MchBaseResult.class, closeorder.getSign_type(), key);
    }

    public static SecapiPayRefundResult secapiPayRefund(SecapiPayRefund secapiPayRefund, String key) {
        Map<String, String> map = MapUtil.objectToMap(secapiPayRefund, new String[0]);
        String sign = SignatureUtil.generateSign(map, secapiPayRefund.getSign_type(), key);
        secapiPayRefund.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(secapiPayRefund);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/secapi/pay/refund").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(secapiPayRefund.getMch_id(), httpUriRequest, SecapiPayRefundResult.class, secapiPayRefund.getSign_type(), key);
    }

    public static MchReverseResult secapiPayReverse(MchReverse mchReverse, String key) {
        Map<String, String> map = MapUtil.objectToMap(mchReverse, new String[0]);
        String sign = SignatureUtil.generateSign(map, mchReverse.getSign_type(), key);
        mchReverse.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(mchReverse);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/secapi/pay/reverse").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(mchReverse.getMch_id(), httpUriRequest, MchReverseResult.class, mchReverse.getSign_type(), key);
    }

    public static RefundqueryResult payRefundquery(Refundquery refundquery, String key) {
        Map<String, String> map = MapUtil.objectToMap(refundquery, new String[0]);
        String sign = SignatureUtil.generateSign(map, refundquery.getSign_type(), key);
        refundquery.setSign(sign);
        String refundqueryXML = XMLConverUtil.convertToXML(refundquery);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/refundquery").setEntity((HttpEntity)new StringEntity(refundqueryXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, RefundqueryResult.class, refundquery.getSign_type(), key);
    }

    public static DownloadbillResult payDownloadbill(MchDownloadbill downloadbill, String key) {
        Map<String, String> map = MapUtil.objectToMap(downloadbill, new String[0]);
        String sign = SignatureUtil.generateSign(map, downloadbill.getSign_type(), key);
        downloadbill.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(downloadbill);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/downloadbill").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.execute(httpUriRequest, new ResponseHandler<DownloadbillResult>(){

            public DownloadbillResult handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    String str = entity.getContentType().getValue().matches("(?i).*gzip.*") ? StreamUtils.copyToString(new GZIPInputStream(entity.getContent()), Charset.forName("UTF-8")) : EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                    EntityUtils.consume((HttpEntity)entity);
                    if (str.startsWith("<xml>")) {
                        return XMLConverUtil.convertToObject(DownloadbillResult.class, str);
                    }
                    DownloadbillResult dr = new DownloadbillResult();
                    dr.setData(str);
                    Header headerDigest = response.getFirstHeader("Digest");
                    if (headerDigest != null) {
                        String[] hkv = headerDigest.getValue().split("=");
                        dr.setSign_type(hkv[0]);
                        dr.setSign(hkv[1]);
                    }
                    return dr;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        });
    }

    public static PayDownloadfundflowResult payDownloadfundflow(PayDownloadfundflow payDownloadfundflow, String key) {
        Map<String, String> map = MapUtil.objectToMap(payDownloadfundflow, new String[0]);
        String sign_type = map.get("sign_type");
        if (sign_type == null || "".equals(sign_type)) {
            sign_type = "HMAC-SHA256";
        }
        String sign = SignatureUtil.generateSign(map, sign_type, key);
        payDownloadfundflow.setSign(sign);
        String xmlData = XMLConverUtil.convertToXML(payDownloadfundflow);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/downloadfundflow").setEntity((HttpEntity)new StringEntity(xmlData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecute(payDownloadfundflow.getMch_id(), httpUriRequest, new ResponseHandler<PayDownloadfundflowResult>(){

            public PayDownloadfundflowResult handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    String str = entity.getContentType().getValue().matches("(?i).*gzip.*") ? StreamUtils.copyToString(new GZIPInputStream(entity.getContent()), Charset.forName("UTF-8")) : EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                    EntityUtils.consume((HttpEntity)entity);
                    if (str.startsWith("<xml>")) {
                        return XMLConverUtil.convertToObject(PayDownloadfundflowResult.class, str);
                    }
                    PayDownloadfundflowResult dr = new PayDownloadfundflowResult();
                    dr.setData(str);
                    Header headerDigest = response.getFirstHeader("Digest");
                    if (headerDigest != null) {
                        String[] hkv = headerDigest.getValue().split("=");
                        dr.setSign_type(hkv[0]);
                        dr.setSign(hkv[1]);
                    }
                    return dr;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        });
    }

    public static MchShorturlResult toolsShorturl(MchShorturl shorturl, String key) {
        Map<String, String> map = MapUtil.objectToMap(shorturl, new String[0]);
        String sign = SignatureUtil.generateSign(map, shorturl.getSign_type(), key);
        shorturl.setSign(sign);
        String shorturlXML = XMLConverUtil.convertToXML(shorturl);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/tools/shorturl").setEntity((HttpEntity)new StringEntity(shorturlXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MchShorturlResult.class, shorturl.getSign_type(), key);
    }

    public static AuthcodetoopenidResult toolsAuthcodetoopenid(Authcodetoopenid authcodetoopenid, String key) {
        Map<String, String> map = MapUtil.objectToMap(authcodetoopenid, new String[0]);
        String sign = SignatureUtil.generateSign(map, authcodetoopenid.getSign_type(), key);
        authcodetoopenid.setSign(sign);
        String shorturlXML = XMLConverUtil.convertToXML(authcodetoopenid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/tools/authcodetoopenid").setEntity((HttpEntity)new StringEntity(shorturlXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, AuthcodetoopenidResult.class, authcodetoopenid.getSign_type(), key);
    }

    public static MchBaseResult payitilReport(Report report, String key) {
        Map<String, String> map = MapUtil.objectToMap(report, new String[0]);
        String sign = SignatureUtil.generateSign(map, report.getSign_type(), key);
        report.setSign(sign);
        String shorturlXML = XMLConverUtil.convertToXML(report);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/payitil/report").setEntity((HttpEntity)new StringEntity(shorturlXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MchBaseResult.class);
    }

    public static SendCouponResult mmpaymkttransfersSend_coupon(SendCoupon sendCoupon, String key) {
        Map<String, String> map = MapUtil.objectToMap(sendCoupon, new String[0]);
        String sign = SignatureUtil.generateSign(map, sendCoupon.getSign_type(), key);
        sendCoupon.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(sendCoupon);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/send_coupon").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(sendCoupon.getMch_id(), httpUriRequest, SendCouponResult.class, sendCoupon.getSign_type(), key);
    }

    public static QueryCouponStockResult mmpaymkttransfersQuery_coupon_stock(QueryCouponStock queryCouponStock, String key) {
        Map<String, String> map = MapUtil.objectToMap(queryCouponStock, new String[0]);
        String sign = SignatureUtil.generateSign(map, queryCouponStock.getSign_type(), key);
        queryCouponStock.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(queryCouponStock);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/query_coupon_stock").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, QueryCouponStockResult.class, queryCouponStock.getSign_type(), key);
    }

    public static QueryCouponResult promotionQuery_coupon(QueryCoupon queryCoupon, String key) {
        Map<String, String> map = MapUtil.objectToMap(queryCoupon, new String[0]);
        String sign = SignatureUtil.generateSign(map, queryCoupon.getSign_type(), key);
        queryCoupon.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(queryCoupon);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/querycouponsinfo").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, QueryCouponResult.class, queryCoupon.getSign_type(), key);
    }

    public static SendredpackResult mmpaymkttransfersSendredpack(Sendredpack sendredpack, String key) {
        Map<String, String> map = MapUtil.objectToMap(sendredpack, new String[0]);
        String sign = SignatureUtil.generateSign(map, sendredpack.getSign_type(), key);
        sendredpack.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(sendredpack);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/sendredpack").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(sendredpack.getMch_id(), httpUriRequest, SendredpackResult.class, sendredpack.getSign_type(), key);
    }

    public static SendredpackResult mmpaymkttransfersSendgroupredpack(Sendgroupredpack sendgroupredpack, String key) {
        Map<String, String> map = MapUtil.objectToMap(sendgroupredpack, new String[0]);
        String sign = SignatureUtil.generateSign(map, sendgroupredpack.getSign_type(), key);
        sendgroupredpack.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(sendgroupredpack);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/sendgroupredpack").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(sendgroupredpack.getMch_id(), httpUriRequest, SendredpackResult.class, sendgroupredpack.getSign_type(), key);
    }

    public static GethbinfoResult mmpaymkttransfersGethbinfo(Gethbinfo gethbinfo, String key) {
        Map<String, String> map = MapUtil.objectToMap(gethbinfo, new String[0]);
        String sign = SignatureUtil.generateSign(map, gethbinfo.getSign_type(), key);
        gethbinfo.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(gethbinfo);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/gethbinfo").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(gethbinfo.getMch_id(), httpUriRequest, GethbinfoResult.class, gethbinfo.getSign_type(), key);
    }

    public static TransfersResult mmpaymkttransfersPromotionTransfers(Transfers transfers, String key) {
        Map<String, String> map = MapUtil.objectToMap(transfers, new String[0]);
        String sign = SignatureUtil.generateSign(map, transfers.getSign_type(), key);
        transfers.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(transfers);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/promotion/transfers").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(transfers.getMchid(), httpUriRequest, TransfersResult.class, transfers.getSign_type(), key);
    }

    public static GettransferinfoResult mmpaymkttransfersGettransferinfo(Gettransferinfo gettransferinfo, String key) {
        Map<String, String> map = MapUtil.objectToMap(gettransferinfo, new String[0]);
        String sign = SignatureUtil.generateSign(map, gettransferinfo.getSign_type(), key);
        gettransferinfo.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(gettransferinfo);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/mmpaymkttransfers/gettransferinfo").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(gettransferinfo.getMch_id(), httpUriRequest, GettransferinfoResult.class, gettransferinfo.getSign_type(), key);
    }

    public static PayContractorderResult payContractorder(PayContractorder payContractorder, String key) {
        Map<String, String> map = MapUtil.objectToMap(payContractorder, new String[0]);
        String sign = SignatureUtil.generateSign(map, payContractorder.getSign_type(), key);
        payContractorder.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(payContractorder);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/contractorder").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, PayContractorderResult.class, payContractorder.getSign_type(), key);
    }

    public static PappayapplyResult payPappayapply(Pappayapply pappayapply, String key) {
        Map<String, String> map = MapUtil.objectToMap(pappayapply, new String[0]);
        String sign = SignatureUtil.generateSign(map, pappayapply.getSign_type(), key);
        pappayapply.setSign(sign);
        String secapiPayRefundXML = XMLConverUtil.convertToXML(pappayapply);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/pappayapply").setEntity((HttpEntity)new StringEntity(secapiPayRefundXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, PappayapplyResult.class, pappayapply.getSign_type(), key);
    }

    public static MchOrderInfoResult payPaporderquery(MchOrderquery mchOrderquery, String key) {
        Map<String, String> map = MapUtil.objectToMap(mchOrderquery, new String[0]);
        String sign = SignatureUtil.generateSign(map, mchOrderquery.getSign_type(), key);
        mchOrderquery.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(mchOrderquery);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/paporderquery").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MchOrderInfoResult.class, mchOrderquery.getSign_type(), key);
    }

    public static PapayQuerycontractResult papayQuerycontract(PapayQuerycontract papayQuerycontract, String key) {
        Map<String, String> map = MapUtil.objectToMap(papayQuerycontract, new String[0]);
        String sign = SignatureUtil.generateSign(map, papayQuerycontract.getSign_type(), key);
        papayQuerycontract.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(papayQuerycontract);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/papay/querycontract").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, PapayQuerycontractResult.class, papayQuerycontract.getSign_type(), key);
    }

    public static PapayDeletecontractResult papayDeletecontract(PapayDeletecontract papayDeletecontract, String key) {
        Map<String, String> map = MapUtil.objectToMap(papayDeletecontract, new String[0]);
        String sign = SignatureUtil.generateSign(map, papayDeletecontract.getSign_type(), key);
        papayDeletecontract.setSign(sign);
        String closeorderXML = XMLConverUtil.convertToXML(papayDeletecontract);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/papay/deletecontract").setEntity((HttpEntity)new StringEntity(closeorderXML, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, PapayDeletecontractResult.class, papayDeletecontract.getSign_type(), key);
    }

    public static PapayH5entrustwebResult papayH5entrustweb(PapayEntrustweb papayEntrustweb, String key) {
        Map<String, String> map = MapUtil.objectToMap(papayEntrustweb, new String[0]);
        String sign = SignatureUtil.generateSign(map, "HMAC-SHA256", key);
        map.put("sign", sign);
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(PayMchAPI.baseURI() + "/papay/h5entrustweb");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null || "".equals(entry.getValue())) continue;
            requestBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        return LocalHttpClient.executeXmlResult(requestBuilder.build(), PapayH5entrustwebResult.class, "HMAC-SHA256", key);
    }

    public static SecapiPayProfitsharingResult secapiPayProfitsharing(SecapiPayProfitsharing secapiPayProfitsharing, String key) {
        Map<String, String> map = MapUtil.objectToMap(secapiPayProfitsharing, "receivers");
        if (secapiPayProfitsharing.getReceivers() != null) {
            map.put("receivers", JsonUtil.toJSONString(secapiPayProfitsharing.getReceivers()));
        }
        String sign = SignatureUtil.generateSign(map, secapiPayProfitsharing.getSign_type() == null ? "HMAC-SHA256" : secapiPayProfitsharing.getSign_type(), key);
        secapiPayProfitsharing.setSign(sign);
        String xml = XMLConverUtil.convertToXML(secapiPayProfitsharing);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/secapi/pay/profitsharing").setEntity((HttpEntity)new StringEntity(xml, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(secapiPayProfitsharing.getMch_id(), httpUriRequest, SecapiPayProfitsharingResult.class, secapiPayProfitsharing.getSign_type() == null ? "HMAC-SHA256" : secapiPayProfitsharing.getSign_type(), key);
    }

    public static SecapiPayProfitsharingResult secapiPayMultiprofitsharing(SecapiPayProfitsharing secapiPayProfitsharing, String key) {
        Map<String, String> map = MapUtil.objectToMap(secapiPayProfitsharing, "receivers");
        if (secapiPayProfitsharing.getReceivers() != null) {
            map.put("receivers", JsonUtil.toJSONString(secapiPayProfitsharing.getReceivers()));
        }
        String sign = SignatureUtil.generateSign(map, secapiPayProfitsharing.getSign_type() == null ? "HMAC-SHA256" : secapiPayProfitsharing.getSign_type(), key);
        secapiPayProfitsharing.setSign(sign);
        String xml = XMLConverUtil.convertToXML(secapiPayProfitsharing);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/secapi/pay/multiprofitsharing").setEntity((HttpEntity)new StringEntity(xml, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(secapiPayProfitsharing.getMch_id(), httpUriRequest, SecapiPayProfitsharingResult.class, secapiPayProfitsharing.getSign_type() == null ? "HMAC-SHA256" : secapiPayProfitsharing.getSign_type(), key);
    }

    public static SecapiPayProfitsharingfinishResult secapiPayProfitsharingfinish(SecapiPayProfitsharingfinish profitsharingfinish, String key) {
        Map<String, String> map = MapUtil.objectToMap(profitsharingfinish, new String[0]);
        String sign = SignatureUtil.generateSign(map, profitsharingfinish.getSign_type() == null ? "HMAC-SHA256" : profitsharingfinish.getSign_type(), key);
        profitsharingfinish.setSign(sign);
        String xml = XMLConverUtil.convertToXML(profitsharingfinish);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/secapi/pay/profitsharingfinish").setEntity((HttpEntity)new StringEntity(xml, Charset.forName("utf-8"))).build();
        return LocalHttpClient.keyStoreExecuteXmlResult(profitsharingfinish.getMch_id(), httpUriRequest, SecapiPayProfitsharingfinishResult.class, profitsharingfinish.getSign_type() == null ? "HMAC-SHA256" : profitsharingfinish.getSign_type(), key);
    }

    public static PayProfitsharingqueryResult payProfitsharingquery(PayProfitsharingquery payProfitsharingquery, String key) {
        Map<String, String> map = MapUtil.objectToMap(payProfitsharingquery, new String[0]);
        String sign = SignatureUtil.generateSign(map, payProfitsharingquery.getSign_type() == null ? "HMAC-SHA256" : payProfitsharingquery.getSign_type(), key);
        payProfitsharingquery.setSign(sign);
        String xml = XMLConverUtil.convertToXML(payProfitsharingquery);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/profitsharingquery").setEntity((HttpEntity)new StringEntity(xml, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, PayProfitsharingqueryResult.class, payProfitsharingquery.getSign_type() == null ? "HMAC-SHA256" : payProfitsharingquery.getSign_type(), key);
    }

    public static MchBaseResult payProfitsharingaddreceiver(PayProfitsharingOperation payProfitsharingOperation, String key) {
        Map<String, String> map = MapUtil.objectToMap(payProfitsharingOperation, "receiver");
        if (payProfitsharingOperation.getReceiver() != null) {
            map.put("receiver", JsonUtil.toJSONString(payProfitsharingOperation.getReceiver()));
        }
        String sign = SignatureUtil.generateSign(map, payProfitsharingOperation.getSign_type() == null ? "HMAC-SHA256" : payProfitsharingOperation.getSign_type(), key);
        payProfitsharingOperation.setSign(sign);
        String xml = XMLConverUtil.convertToXML(payProfitsharingOperation);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/profitsharingaddreceiver").setEntity((HttpEntity)new StringEntity(xml, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MchBaseResult.class, payProfitsharingOperation.getSign_type() == null ? "HMAC-SHA256" : payProfitsharingOperation.getSign_type(), key);
    }

    public static MchBaseResult payProfitsharingremovereceiver(PayProfitsharingOperation payProfitsharingOperation, String key) {
        Map<String, String> map = MapUtil.objectToMap(payProfitsharingOperation, "receiver");
        if (payProfitsharingOperation.getReceiver() != null) {
            map.put("receiver", JsonUtil.toJSONString(payProfitsharingOperation.getReceiver()));
        }
        String sign = SignatureUtil.generateSign(map, payProfitsharingOperation.getSign_type() == null ? "HMAC-SHA256" : payProfitsharingOperation.getSign_type(), key);
        payProfitsharingOperation.setSign(sign);
        String xml = XMLConverUtil.convertToXML(payProfitsharingOperation);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(xmlHeader).setUri(PayMchAPI.baseURI() + "/pay/profitsharingremovereceiver").setEntity((HttpEntity)new StringEntity(xml, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeXmlResult(httpUriRequest, MchBaseResult.class, payProfitsharingOperation.getSign_type() == null ? "HMAC-SHA256" : payProfitsharingOperation.getSign_type(), key);
    }
}

