/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.wxaapi.AddTemplateResult;
import weixin.popular.bean.wxaapi.GetCategoryResult;
import weixin.popular.bean.wxaapi.GetPriTemplateListResult;
import weixin.popular.bean.wxaapi.GetPubTemplateKeywordsResult;
import weixin.popular.bean.wxaapi.GetPubTemplateTitlesResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;

public class WxaapiAPI
extends BaseAPI {
    public static AddTemplateResult addTemplate(String access_token, String tid, List<Integer> kidList, String sceneDesc) {
        String json = String.format("{\"tid\":\"%s\",\"kidList\":%s,\"sceneDesc\":\"%s\"}", tid, JsonUtil.toJSONString(kidList), sceneDesc);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, AddTemplateResult.class);
    }

    public static BaseResult delTemplate(String access_token, String priTmplId) {
        String json = String.format("{\"priTmplId\":\"%s\"}", priTmplId);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxaapi/newtmpl/deltemplate").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static GetCategoryResult getCategory(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxaapi/newtmpl/getcategory").addParameter("access_token", API.accessToken(access_token)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetCategoryResult.class);
    }

    public static GetPubTemplateTitlesResult getPubTemplateTitles(String access_token, String ids, Integer start, Integer limit) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatetitles").addParameter("access_token", API.accessToken(access_token)).addParameter("ids", ids).addParameter("start", String.valueOf(start)).addParameter("limit", String.valueOf(limit)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetPubTemplateTitlesResult.class);
    }

    public static GetPubTemplateKeywordsResult getPubTemplateKeywords(String access_token, String tid) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatekeywords").addParameter("access_token", API.accessToken(access_token)).addParameter("tid", tid).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetPubTemplateKeywordsResult.class);
    }

    public static GetPriTemplateListResult getPriTemplateList(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate").addParameter("access_token", API.accessToken(access_token)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetPriTemplateListResult.class);
    }
}

