/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.HeldCertificate;

public final class SslClient {
    private static SslClient localhost;
    public final SSLContext sslContext;
    public final SSLSocketFactory socketFactory;
    public final X509TrustManager trustManager;

    private SslClient(SSLContext sslContext, X509TrustManager trustManager) {
        this.sslContext = sslContext;
        this.socketFactory = sslContext.getSocketFactory();
        this.trustManager = trustManager;
    }

    public static synchronized SslClient localhost() {
        if (localhost != null) {
            return localhost;
        }
        try {
            HeldCertificate heldCertificate = new HeldCertificate.Builder().serialNumber("1").commonName(InetAddress.getByName("localhost").getCanonicalHostName()).build();
            localhost = new Builder().certificateChain(heldCertificate.keyPair, heldCertificate.certificate, new X509Certificate[0]).addTrustedCertificate(heldCertificate.certificate).build();
            return localhost;
        }
        catch (UnknownHostException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private final List<X509Certificate> chainCertificates = new ArrayList<X509Certificate>();
        private final List<X509Certificate> certificates = new ArrayList<X509Certificate>();
        private KeyPair keyPair;
        private String keyStoreType = KeyStore.getDefaultType();
        private SSLContext sslContext;

        public Builder certificateChain(HeldCertificate localCert, HeldCertificate ... chain) {
            X509Certificate[] certificates = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                certificates[i] = chain[i].certificate;
            }
            return this.certificateChain(localCert.keyPair, localCert.certificate, certificates);
        }

        public Builder certificateChain(KeyPair keyPair, X509Certificate keyCert, X509Certificate ... certificates) {
            this.keyPair = keyPair;
            this.chainCertificates.add(keyCert);
            this.chainCertificates.addAll(Arrays.asList(certificates));
            this.certificates.addAll(Arrays.asList(certificates));
            return this;
        }

        public Builder addTrustedCertificate(X509Certificate certificate) {
            this.certificates.add(certificate);
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public SslClient build() {
            try {
                char[] password = "password".toCharArray();
                KeyStore keyStore = this.newEmptyKeyStore(password);
                if (this.keyPair != null) {
                    Certificate[] certificates = this.chainCertificates.toArray(new Certificate[this.chainCertificates.size()]);
                    keyStore.setKeyEntry("private", this.keyPair.getPrivate(), password, certificates);
                }
                for (int i = 0; i < this.certificates.size(); ++i) {
                    keyStore.setCertificateEntry("cert_" + i, this.certificates.get(i));
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, password);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                SSLContext activeSslContext = this.sslContext != null ? this.sslContext : Platform.get().getSSLContext();
                activeSslContext.init(keyManagerFactory.getKeyManagers(), (TrustManager[])trustManagers, new SecureRandom());
                return new SslClient(activeSslContext, (X509TrustManager)trustManagers[0]);
            }
            catch (GeneralSecurityException gse) {
                throw new AssertionError((Object)gse);
            }
        }

        private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
            try {
                KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
                InputStream in = null;
                keyStore.load(in, password);
                return keyStore;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

