/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Version;
import okio.ByteString;

public final class AutobahnTester {
    private static final String HOST = "ws://localhost:9099";
    final OkHttpClient client = new OkHttpClient();

    public static void main(String ... args) throws IOException {
        new AutobahnTester().run();
    }

    private WebSocket newWebSocket(String path, WebSocketListener listener) {
        Request request = new Request.Builder().url(HOST + path).build();
        return this.client.newWebSocket(request, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            long count = this.getTestCount();
            System.out.println("Test count: " + count);
            for (long number = 1L; number <= count; ++number) {
                this.runTest(number, count);
            }
            this.updateReports();
        }
        finally {
            this.client.dispatcher().executorService().shutdown();
        }
    }

    private void runTest(final long number, final long count) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong startNanos = new AtomicLong();
        this.newWebSocket("/runCase?case=" + number + "&agent=okhttp", new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                System.out.println("Executing test case " + number + "/" + count);
                startNanos.set(System.nanoTime());
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                webSocket.send(bytes);
            }

            public void onMessage(WebSocket webSocket, String text) {
                webSocket.send(text);
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(1000, null);
                latch.countDown();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                t.printStackTrace(System.out);
                latch.countDown();
            }
        });
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out waiting for test " + number + " to finish.");
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        long endNanos = System.nanoTime();
        long tookMs = TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos.get());
        System.out.println("Took " + tookMs + "ms");
    }

    private long getTestCount() throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong countRef = new AtomicLong();
        final AtomicReference failureRef = new AtomicReference();
        this.newWebSocket("/getCaseCount", new WebSocketListener(){

            public void onMessage(WebSocket webSocket, String text) {
                countRef.set(Long.parseLong(text));
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(1000, null);
                latch.countDown();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                failureRef.set(t);
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out waiting for count.");
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        Throwable failure = (Throwable)failureRef.get();
        if (failure != null) {
            throw new RuntimeException(failure);
        }
        return countRef.get();
    }

    private void updateReports() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.newWebSocket("/updateReports?agent=" + Version.userAgent(), new WebSocketListener(){

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(1000, null);
                latch.countDown();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out waiting for count.");
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
    }
}

