/*
 * Decompiled with CFR 0.152.
 */
package com.lassekoskela.maven.buildevents;

import com.lassekoskela.maven.buildevents.BuildEventLog;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;

public class BuildEventListener
extends AbstractExecutionListener {
    private final BuildEventLog log;

    public BuildEventListener(BuildEventLog buildEventLog) {
        this.log = buildEventLog;
    }

    public void sessionEnded(ExecutionEvent event) {
        this.log.report();
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.log(event);
    }

    public void mojoStarted(ExecutionEvent event) {
        MojoExecution mojo = event.getMojoExecution();
        String phase = mojo.getLifecyclePhase();
        String project = event.getProject().getArtifactId();
        this.log.start(project, phase, mojo.getGroupId(), mojo.getArtifactId(), mojo.getGoal());
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.mojoEnded(event);
    }

    public void mojoFailed(ExecutionEvent event) {
        this.mojoEnded(event);
    }

    private void mojoEnded(ExecutionEvent event) {
        MojoExecution mojo = event.getMojoExecution();
        String phase = mojo.getLifecyclePhase();
        String project = event.getProject().getArtifactId();
        this.log.end(project, phase, mojo.getGroupId(), mojo.getArtifactId(), mojo.getGoal());
    }

    private void log(ExecutionEvent event) {
        MojoExecution mojo = event.getMojoExecution();
        String phase = mojo.getLifecyclePhase();
        String project = event.getProject().getArtifactId();
        this.log.end(project, phase, mojo.getGroupId(), mojo.getArtifactId(), mojo.getGoal());
    }
}

