/*
 * Decompiled with CFR 0.152.
 */
package com.lassekoskela.maven.buildevents;

import com.lassekoskela.maven.buildevents.BuildEventLogReport;
import com.lassekoskela.maven.buildevents.BuildStep;
import com.lassekoskela.maven.logging.Log;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEventLog {
    private final Log logger;
    private final List<BuildStep> steps;
    private BuildStep latestStep;

    public BuildEventLog(Log logger) {
        this.logger = logger;
        this.steps = new ArrayList<BuildStep>();
    }

    public void start(String project, String phase, String groupId, String artifactId, String goal) {
        this.latestStep = new BuildStep(project, phase, groupId, artifactId, goal);
        this.latestStep.start();
    }

    public void end(String project, String phase, String groupId, String artifactId, String goal) {
        this.latestStep.end();
        this.steps.add(this.latestStep);
    }

    public void report() {
        this.createReport().report();
    }

    public long totalDuration() {
        return this.createReport().totalDuration();
    }

    public long totalDurationOfProject(String project) {
        return this.createReport().totalDurationOfProject(project);
    }

    public long totalDurationOfPhase(String phase) {
        return this.createReport().totalDurationOfPhase(phase);
    }

    public long totalDurationOfPhase(String project, String phase) {
        return this.createReport().totalDurationOfPhase(project, phase);
    }

    protected BuildEventLogReport createReport(Log log, List<BuildStep> steps) {
        BuildEventLogReport report = new BuildEventLogReport(log);
        report.add(steps);
        return report;
    }

    private BuildEventLogReport createReport() {
        return this.createReport(this.logger, this.steps);
    }
}

