/*
 * Decompiled with CFR 0.152.
 */
package com.lassekoskela.maven.buildevents;

import ch.lambdaj.collection.LambdaCollections;
import com.lassekoskela.maven.buildevents.BuildStep;
import com.lassekoskela.maven.buildevents.FieldMatcher;
import com.lassekoskela.maven.logging.Log;
import com.lassekoskela.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildEventLogReport {
    private final Log log;
    private final List<BuildStep> steps;

    public BuildEventLogReport(Log log) {
        this(log, new ArrayList<BuildStep>());
    }

    public BuildEventLogReport(Log log, List<BuildStep> steps) {
        this.log = log;
        this.steps = steps;
    }

    public void report() {
        this.printHeader();
        this.reportBuildSteps(this.steps);
        this.printFooter();
    }

    private void reportBuildSteps(List<BuildStep> steps) {
        String currentProject = "";
        String currentPhase = "";
        long totalDuration = this.totalDuration();
        for (BuildStep buildStep : steps) {
            this.reportBuildStep(currentProject, currentPhase, buildStep, totalDuration);
            currentPhase = buildStep.phase;
            currentProject = buildStep.project;
        }
    }

    private void reportBuildStep(String currentProject, String currentPhase, BuildStep buildStep, long totalDuration) {
        String project = buildStep.project;
        String phase = buildStep.phase;
        long phaseDuration = this.totalDurationOfPhase(project, phase);
        long projectDuration = this.totalDurationOfProject(project);
        long percentageOfPhase = (long)buildStep.duration().percentageOf(phaseDuration);
        if (project != null && !project.equals(currentProject)) {
            this.log.info("");
            this.reportProjectStatistics(project, totalDuration, projectDuration);
        }
        if (phase != null && !phase.equals(currentPhase)) {
            this.reportPhaseStatistics(phase, projectDuration, phaseDuration);
        }
        this.reportGoalStatistics(buildStep, percentageOfPhase);
    }

    private void reportGoalStatistics(BuildStep buildStep, long percentage) {
        String goal = buildStep.artifactId + ":" + buildStep.goal;
        double seconds = buildStep.duration().inSeconds();
        this.log.info(String.format("    %-54s %7.1fs %3s%%", goal, seconds, percentage));
    }

    private void reportPhaseStatistics(String phase, long totalDuration, long totalDurationOfPhase) {
        Duration phaseDuration = new Duration(totalDurationOfPhase);
        long percentage = (long)phaseDuration.percentageOf(totalDuration);
        double seconds = phaseDuration.inSeconds();
        this.log.info(String.format("%-58s %7.1fs %3s%%", "  " + phase, seconds, percentage));
    }

    private void reportProjectStatistics(String project, long totalDuration, long totalDurationOfProject) {
        Duration projectDuration = new Duration(totalDurationOfProject);
        long percentage = (long)projectDuration.percentageOf(totalDuration);
        double seconds = projectDuration.inSeconds();
        this.log.info(String.format("%-58s %7.1fs %3s%%", "*" + project, seconds, percentage));
    }

    public long totalDurationOfPhase(String phase) {
        long total = 0L;
        for (BuildStep e : this.filter(this.steps, this.phase(phase))) {
            total += e.duration().inMillis();
        }
        return total;
    }

    public long totalDurationOfPhase(String project, String phase) {
        long total = 0L;
        for (BuildStep e : this.filter(this.steps, this.project(project), this.phase(phase))) {
            total += e.duration().inMillis();
        }
        return total;
    }

    private List<BuildStep> filter(List<BuildStep> steps, Matcher<BuildStep> ... matchers) {
        return LambdaCollections.with(steps).clone().retain(Matchers.allOf(matchers));
    }

    private Matcher<BuildStep> project(String project) {
        return new FieldMatcher("project", project);
    }

    private Matcher<BuildStep> phase(String phase) {
        return new FieldMatcher("phase", phase);
    }

    public long totalDurationOfProject(String project) {
        long total = 0L;
        for (BuildStep e : this.filter(this.steps, this.project(project))) {
            total += e.duration().inMillis();
        }
        return total;
    }

    public long totalDuration() {
        long totalDuration = 0L;
        for (BuildStep e : this.steps) {
            totalDuration += e.duration().inMillis();
        }
        return totalDuration;
    }

    public void add(List<BuildStep> steps) {
        this.steps.addAll(steps);
    }

    private void printFooter() {
        this.log.info("------------------------------------------------------------------------");
    }

    private void printHeader() {
        this.log.info("------------------------- BUILD STEP DURATIONS -------------------------");
        this.log.info("PROJECT                                                    DURATION     ");
        this.log.info("| PHASE                                                       PERCENTAGE");
        this.log.info("| | GOAL                                                          |    |");
        this.log.info("| | |                                                             |    |");
    }
}

