/*
 * Decompiled with CFR 0.152.
 */
package com.lassekoskela.maven.buildevents;

import com.lassekoskela.time.Clock;
import com.lassekoskela.time.Duration;

public class BuildStep {
    public final String project;
    public final String phase;
    public final String groupId;
    public final String artifactId;
    public final String goal;
    private long startedAt;
    private long endedAt;

    public BuildStep(String project, String phase, String groupId, String artifactId, String goal) {
        this.project = project;
        this.phase = phase;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.goal = goal;
    }

    public Duration duration() {
        return new Duration(this.endedAt - this.startedAt);
    }

    public void end() {
        this.endedAt = Clock.now();
    }

    public void start() {
        this.startedAt = Clock.now();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName()).append("(");
        s.append(this.project).append("/").append(this.phase).append("/");
        s.append(this.groupId).append(":").append(this.artifactId);
        s.append("/").append(this.goal).append(")");
        return s.toString();
    }
}

